---
UID: NE:winevt._EVT_CHANNEL_REFERENCE_FLAGS
title: EVT_CHANNEL_REFERENCE_FLAGS (winevt.h)
description: Defines the values that specify how a channel is referenced.
old-location: wes\evt_channel_reference_flags.htm
tech.root: wes
ms.assetid: 4f86dce0-1b01-4258-af86-b3fe1eca010a
ms.date: 12/05/2018
ms.keywords: EVT_CHANNEL_REFERENCE_FLAGS, EVT_CHANNEL_REFERENCE_FLAGS enumeration [EventLog], EvtChannelReferenceImported, wes.evt_channel_reference_flags, winevt/EVT_CHANNEL_REFERENCE_FLAGS, winevt/EvtChannelReferenceImported
f1_keywords:
- winevt/EVT_CHANNEL_REFERENCE_FLAGS
dev_langs:
- c++
req.header: winevt.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- WinEvt.h
api_name:
- EVT_CHANNEL_REFERENCE_FLAGS
targetos: Windows
req.typenames: EVT_CHANNEL_REFERENCE_FLAGS
req.redist: 
ms.custom: 19H1
---

# EVT_CHANNEL_REFERENCE_FLAGS enumeration


## -description


Defines the values that specify how a channel is referenced.


## -enum-fields




### -field EvtChannelReferenceImported

Specifies that the channel is imported.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/winevt/ne-winevt-evt_channel_config_property_id">EVT_CHANNEL_CONFIG_PROPERTY_ID</a>



<a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtgetchannelconfigproperty">EvtGetChannelConfigProperty</a>



<a href="https://docs.microsoft.com/windows/desktop/WES/eventmanifestschema-importchanneltype-complextype">ImportChannelType Complex Type</a>
 

 

