---
UID: NE:winevt._EVT_PUBLISHER_METADATA_PROPERTY_ID
title: EVT_PUBLISHER_METADATA_PROPERTY_ID (winevt.h)
description: Defines the identifiers that identify the metadata properties of a provider.
old-location: wes\evt_publisher_metadata_property_id.htm
tech.root: wes
ms.assetid: 10f4917d-68a1-4e90-ad7f-6bc19471ec38
ms.date: 12/05/2018
ms.keywords: EVT_PUBLISHER_METADATA_PROPERTY_ID, EVT_PUBLISHER_METADATA_PROPERTY_ID enumeration [EventLog], EvtPublisherMetadataChannelReferenceFlags, EvtPublisherMetadataChannelReferenceID, EvtPublisherMetadataChannelReferenceIndex, EvtPublisherMetadataChannelReferenceMessageID, EvtPublisherMetadataChannelReferencePath, EvtPublisherMetadataChannelReferences, EvtPublisherMetadataHelpLink, EvtPublisherMetadataKeywordMessageID, EvtPublisherMetadataKeywordName, EvtPublisherMetadataKeywordValue, EvtPublisherMetadataKeywords, EvtPublisherMetadataLevelMessageID, EvtPublisherMetadataLevelName, EvtPublisherMetadataLevelValue, EvtPublisherMetadataLevels, EvtPublisherMetadataMessageFilePath, EvtPublisherMetadataOpcodeMessageID, EvtPublisherMetadataOpcodeName, EvtPublisherMetadataOpcodeValue, EvtPublisherMetadataOpcodes, EvtPublisherMetadataParameterFilePath, EvtPublisherMetadataPropertyIdEND, EvtPublisherMetadataPublisherGuid, EvtPublisherMetadataPublisherMessageID, EvtPublisherMetadataResourceFilePath, EvtPublisherMetadataTaskEventGuid, EvtPublisherMetadataTaskMessageID, EvtPublisherMetadataTaskName, EvtPublisherMetadataTaskValue, EvtPublisherMetadataTasks, wes.evt_publisher_metadata_property_id, winevt/EVT_PUBLISHER_METADATA_PROPERTY_ID, winevt/EvtPublisherMetadataChannelReferenceFlags, winevt/EvtPublisherMetadataChannelReferenceID, winevt/EvtPublisherMetadataChannelReferenceIndex, winevt/EvtPublisherMetadataChannelReferenceMessageID, winevt/EvtPublisherMetadataChannelReferencePath, winevt/EvtPublisherMetadataChannelReferences, winevt/EvtPublisherMetadataHelpLink, winevt/EvtPublisherMetadataKeywordMessageID, winevt/EvtPublisherMetadataKeywordName, winevt/EvtPublisherMetadataKeywordValue, winevt/EvtPublisherMetadataKeywords, winevt/EvtPublisherMetadataLevelMessageID, winevt/EvtPublisherMetadataLevelName, winevt/EvtPublisherMetadataLevelValue, winevt/EvtPublisherMetadataLevels, winevt/EvtPublisherMetadataMessageFilePath, winevt/EvtPublisherMetadataOpcodeMessageID, winevt/EvtPublisherMetadataOpcodeName, winevt/EvtPublisherMetadataOpcodeValue, winevt/EvtPublisherMetadataOpcodes, winevt/EvtPublisherMetadataParameterFilePath, winevt/EvtPublisherMetadataPropertyIdEND, winevt/EvtPublisherMetadataPublisherGuid, winevt/EvtPublisherMetadataPublisherMessageID, winevt/EvtPublisherMetadataResourceFilePath, winevt/EvtPublisherMetadataTaskEventGuid, winevt/EvtPublisherMetadataTaskMessageID, winevt/EvtPublisherMetadataTaskName, winevt/EvtPublisherMetadataTaskValue, winevt/EvtPublisherMetadataTasks
f1_keywords:
- winevt/EVT_PUBLISHER_METADATA_PROPERTY_ID
dev_langs:
- c++
req.header: winevt.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- WinEvt.h
api_name:
- EVT_PUBLISHER_METADATA_PROPERTY_ID
targetos: Windows
req.typenames: EVT_PUBLISHER_METADATA_PROPERTY_ID
req.redist: 
ms.custom: 19H1
---

# EVT_PUBLISHER_METADATA_PROPERTY_ID enumeration


## -description


Defines the identifiers that identify the metadata properties of a provider.


## -enum-fields




### -field EvtPublisherMetadataPublisherGuid

Identifies the <b>guid</b> attribute of the provider. The variant type for this property is <b>EvtVarTypeGuid</b>.


### -field EvtPublisherMetadataResourceFilePath

Identifies the <b>resourceFilePath</b> attribute of the provider. The variant type for this property is <b>EvtVarTypeString</b>.


### -field EvtPublisherMetadataParameterFilePath

Identifies the <b>parameterFilePath</b> attribute of the provider. The variant type for this property is <b>EvtVarTypeString</b>.


### -field EvtPublisherMetadataMessageFilePath

Identifies the <b>messageFilePath</b> attribute of the provider. The variant type for this property is <b>EvtVarTypeString</b>.


### -field EvtPublisherMetadataHelpLink

Identifies the <b>helpLink</b> attribute of the provider. The variant type for this property is <b>EvtVarTypeString</b>.


### -field EvtPublisherMetadataPublisherMessageID

Identifies the <b>message</b> attribute of the provider. The metadata is the resource identifier assigned to the message string. To get the message string, call the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtformatmessage">EvtFormatMessage</a> function. The variant type for this property is <b>EvtVarTypeUInt32</b>. If the provider does not specify a message, the value is –1.


### -field EvtPublisherMetadataChannelReferences

Identifies the <b>channels</b> child element of the provider. The variant type for this property is <b>EvtVarTypeEvtHandle</b>. To access the metadata of the channels that the provider defines or imports, use this handle when calling the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtgetobjectarrayproperty">EvtGetObjectArrayProperty</a> function. For details, see Remarks. When you are done with the handle, call the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtclose">EvtClose</a> function.


### -field EvtPublisherMetadataChannelReferencePath

Identifies the <b>name</b> attribute of the channel. Use this identifier when calling the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtgetobjectarrayproperty">EvtGetObjectArrayProperty</a> function. For details, see Remarks. The variant type for this property is <b>EvtVarTypeString</b>.


### -field EvtPublisherMetadataChannelReferenceIndex

Identifies the zero-based index value of the channel in the list of channels. Use this identifier when calling the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtgetobjectarrayproperty">EvtGetObjectArrayProperty</a> function. For details, see Remarks. The variant type for this property is <b>EvtVarTypeUInt32</b>.


### -field EvtPublisherMetadataChannelReferenceID

Identifies the <b>value</b> attribute of the channel. Use this identifier when calling the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtgetobjectarrayproperty">EvtGetObjectArrayProperty</a> function. For details, see Remarks. The variant type for this property is <b>EvtVarTypeUInt32</b>.


### -field EvtPublisherMetadataChannelReferenceFlags

Identifies the flags value that indicates whether this channel is imported from another provider. The channel is imported if the EvtChannelReferenceImported flag value is set. Use this identifier when calling the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtgetobjectarrayproperty">EvtGetObjectArrayProperty</a> function. For details, see Remarks. The variant type for this property is <b>EvtVarTypeUInt32</b>.


### -field EvtPublisherMetadataChannelReferenceMessageID

Identifies the <b>message</b> attribute of the channel. Use this identifier when calling the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtgetobjectarrayproperty">EvtGetObjectArrayProperty</a> function. For details, see Remarks. The variant type for this property is <b>EvtVarTypeUInt32</b>. The property contains the resource identifier that is assigned to the message string. To get the message string, call the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtformatmessage">EvtFormatMessage</a> function. If the channel does not specify a message, the value is –1.


### -field EvtPublisherMetadataLevels

Identifies the <b>levels</b> child element of the provider. The variant type for this property is <b>EvtVarTypeEvtHandle</b>. To access the metadata of the levels that the provider defines or references, use this handle when calling the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtgetobjectarrayproperty">EvtGetObjectArrayProperty</a> function. For details, see Remarks. When you are done with the handle, call the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtclose">EvtClose</a> function.


### -field EvtPublisherMetadataLevelName

Identifies the <b>name</b> attribute of the level. Use this identifier when calling the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtgetobjectarrayproperty">EvtGetObjectArrayProperty</a> function. For details, see Remarks. The variant type for this property is <b>EvtVarTypeString</b>.


### -field EvtPublisherMetadataLevelValue

Identifies the <b>value</b> attribute of the level. Use this identifier when calling the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtgetobjectarrayproperty">EvtGetObjectArrayProperty</a> function. For details, see Remarks. The variant type for this property is <b>EvtVarTypeUInt32</b>.


### -field EvtPublisherMetadataLevelMessageID

Identifies the <b>message</b> attribute of the level. Use this identifier when calling the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtgetobjectarrayproperty">EvtGetObjectArrayProperty</a> function. For details, see Remarks. The variant type for this property is <b>EvtVarTypeUInt32</b>. The property contains the resource identifier that is assigned to the message string. To get the message string, call the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtformatmessage">EvtFormatMessage</a> function. If the level does not specify a message, the value is –1.


### -field EvtPublisherMetadataTasks

Identifies the <b>tasks</b> child element of the provider. The variant type for this property is <b>EvtVarTypeEvtHandle</b>. To access the metadata of the tasks that the provider defines, use this handle when calling the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtgetobjectarrayproperty">EvtGetObjectArrayProperty</a> function. For details, see Remarks. When you are done with the handle, call the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtclose">EvtClose</a> function.


### -field EvtPublisherMetadataTaskName

Identifies the <b>name</b> attribute of the task. Use this identifier when calling the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtgetobjectarrayproperty">EvtGetObjectArrayProperty</a> function. For details, see Remarks. The variant type for this property is <b>EvtVarTypeString</b>.


### -field EvtPublisherMetadataTaskEventGuid

Identifies the <b>eventGuid</b> attribute of the task. Use this identifier when calling the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtgetobjectarrayproperty">EvtGetObjectArrayProperty</a> function. For details, see Remarks. The variant type for this property is <b>EvtVarTypeString</b>.


### -field EvtPublisherMetadataTaskValue

Identifies the <b>value</b> attribute of the task. Use this identifier when calling the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtgetobjectarrayproperty">EvtGetObjectArrayProperty</a> function. For details, see Remarks. The variant type for this property is <b>EvtVarTypeUInt32</b>.


### -field EvtPublisherMetadataTaskMessageID

Identifies the <b>message</b> attribute of the task. Use this identifier when calling the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtgetobjectarrayproperty">EvtGetObjectArrayProperty</a> function. For details, see Remarks. The variant type for this property is <b>EvtVarTypeUInt32</b>. The property contains the resource identifier that is assigned to the message string. To get the message string, call the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtformatmessage">EvtFormatMessage</a> function. If the task does not specify a message, the value is –1.


### -field EvtPublisherMetadataOpcodes

Identifies the <b>opcodes</b> child element of the provider. The variant type for this property is <b>EvtVarTypeEvtHandle</b>. To access the metadata of the opcodes that the provider defines or references, use this handle when calling the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtgetobjectarrayproperty">EvtGetObjectArrayProperty</a> function. For details, see Remarks. When you are done with the handle, call the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtclose">EvtClose</a> function.


### -field EvtPublisherMetadataOpcodeName

Identifies the <b>name</b> attribute of the opcode. Use this identifier when calling the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtgetobjectarrayproperty">EvtGetObjectArrayProperty</a> function. For details, see Remarks. The variant type for this property is <b>EvtVarTypeString</b>.


### -field EvtPublisherMetadataOpcodeValue

Identifies the <b>value</b> attribute of the opcode. Use this identifier when calling the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtgetobjectarrayproperty">EvtGetObjectArrayProperty</a> function. For details, see Remarks. The variant type for this property is <b>EvtVarTypeUInt32</b>. The high word contains the opcode value and the low word contains the task to which it belongs. If the low word is zero, the opcode is defined globally; otherwise, the opcode is task specific. Use the low word value to determine the task that defines the opcode. 


### -field EvtPublisherMetadataOpcodeMessageID

Identifies the <b>message</b> attribute of the opcode. Use this identifier when calling the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtgetobjectarrayproperty">EvtGetObjectArrayProperty</a> function. For details, see Remarks. The variant type for this property is <b>EvtVarTypeUInt32</b>. The property contains the resource identifier that is assigned to the message string. To get the message string, call the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtformatmessage">EvtFormatMessage</a> function. If the opcode does not specify a message, the value is –1.


### -field EvtPublisherMetadataKeywords

Identifies the <b>keywords</b> child element of the provider. The variant type for this property is <b>EvtVarTypeEvtHandle</b>. To access the metadata of the keywords that the provider defines, use this handle when calling the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtgetobjectarrayproperty">EvtGetObjectArrayProperty</a> function. For details, see Remarks. When you are done with the handle, call the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtclose">EvtClose</a> function.


### -field EvtPublisherMetadataKeywordName

Identifies the <b>name</b> attribute of the keyword. Use this identifier when calling the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtgetobjectarrayproperty">EvtGetObjectArrayProperty</a> function. For details, see Remarks. The variant type for this property is <b>EvtVarTypeString</b>.


### -field EvtPublisherMetadataKeywordValue

Identifies the <b>mask</b> attribute of the keyword. Use this identifier when calling the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtgetobjectarrayproperty">EvtGetObjectArrayProperty</a> function. For details, see Remarks. The variant type for this property is <b>EvtVarTypeUInt64</b>.


### -field EvtPublisherMetadataKeywordMessageID

Identifies the <b>message</b> attribute of the keyword. Use this identifier when calling the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtgetobjectarrayproperty">EvtGetObjectArrayProperty</a> function. For details, see Remarks. The variant type for this property is <b>EvtVarTypeUInt32</b>. The property contains the resource identifier that is assigned to the message string. To get the message string, call the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtformatmessage">EvtFormatMessage</a> function. If the keyword does not specify a message, the value is –1.


### -field EvtPublisherMetadataPropertyIdEND

This enumeration value marks the end of the enumeration values.


## -remarks



This list of identifiers in this enumeration are for those properties that cannot change. To get the configuration for a channel, call the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtgetchannelconfigproperty">EvtGetChannelConfigProperty</a> function.

You cannot use the following property identifiers when calling the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtgetpublishermetadataproperty">EvtGetPublisherMetadataProperty</a> function: 

<ul>
<li><b>EvtPublisherMetadataChannelReferencePath</b></li>
<li><b>EvtPublisherMetadataChannelReferenceIndex</b></li>
<li><b>EvtPublisherMetadataChannelReferenceID</b></li>
<li><b>EvtPublisherMetadataChannelReferenceFlags</b></li>
<li><b>EvtPublisherMetadataChannelReferenceMessageID</b></li>
<li><b>EvtPublisherMetadataLevelName</b></li>
<li><b>EvtPublisherMetadataLevelValue</b></li>
<li><b>EvtPublisherMetadataLevelMessageID</b></li>
<li><b>EvtPublisherMetadataTaskName</b></li>
<li><b>EvtPublisherMetadataTaskEventGuid</b></li>
<li><b>EvtPublisherMetadataTaskValue</b></li>
<li><b>EvtPublisherMetadataTaskMessageID</b></li>
<li><b>EvtPublisherMetadataOpcodeName</b></li>
<li><b>EvtPublisherMetadataOpcodeValue</b></li>
<li><b>EvtPublisherMetadataOpcodeMessageID</b></li>
<li><b>EvtPublisherMetadataKeywordName</b></li>
<li><b>EvtPublisherMetadataKeywordValue</b></li>
<li><b>EvtPublisherMetadataKeywordMessageID</b></li>
</ul>
To use these identifiers, you must first retrieve the handle to the property's parent object.  To retrieve the channel properties, you must first retrieve the handle to the parent object using the <b>EvtPublisherMetadataChannelReferences</b> identifier; to retrieve the level properties, you must first retrieve the handle to the parent object using the <b>EvtPublisherMetadataLevels</b> identifier; to retrieve the task properties, you must first retrieve the handle to the parent object using the <b>EvtPublisherMetadataTasks</b> identifier; to retrieve the opcode properties, you must first retrieve the handle to the parent object using the <b>EvtPublisherMetadataOpcodes</b> identifier; and to retrieve the keyword properties, you must first retrieve the handle to the parent object using the <b>EvtPublisherMetadataKeywords</b> identifier. 

The handle points to an array of objects that contain the metadata for child type that the provider defines. To determine how many objects are in the array, call the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtgetobjectarraysize">EvtGetObjectArraySize</a> function. To access a property of one of the objects, call the <a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtgetobjectarrayproperty">EvtGetObjectArrayProperty</a> function and specify the identifier of the property that you want to retrieve.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/WES/eventmanifestschema-channeltype-complextype">ChannelType Complex Type</a>



<a href="https://docs.microsoft.com/windows/desktop/api/winevt/ne-winevt-evt_event_metadata_property_id">EVT_EVENT_METADATA_PROPERTY_ID</a>



<a href="https://docs.microsoft.com/windows/desktop/api/winevt/ne-winevt-evt_variant_type">EVT_VARIANT_TYPE</a>



<a href="https://docs.microsoft.com/windows/desktop/api/winevt/nf-winevt-evtgetpublishermetadataproperty">EvtGetPublisherMetadataProperty</a>



<a href="https://docs.microsoft.com/windows/desktop/WES/eventmanifestschema-providertype-complextype">ProviderType Complex Type</a>
 

 

