---
UID: NF:wingdi.CMYK
title: CMYK macro (wingdi.h)
description: The CMYK macro creates a CMYK color value by combining the specified cyan, magenta, yellow, and black values.
old-location: wcs\cmyk.htm
tech.root: WCS
ms.assetid: ee28d4e3-314f-429d-841b-da432ff6dc78
ms.date: 12/05/2018
ms.keywords: CMYK, CMYK macro [Windows Color System], _color_CMYK, wcs.cmyk, wingdi/CMYK
f1_keywords:
- wingdi/CMYK
dev_langs:
- c++
req.header: wingdi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Wingdi.h
api_name:
- CMYK
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# CMYK macro


## -description



The <b>CMYK</b> macro creates a CMYK color value by combining the specified cyan, magenta, yellow, and black values.




## -parameters




### -param c

The cyan value for the color to be created.


### -param m

The magenta value for the color to be created.


### -param y

The yellow value for the color to be created.


### -param k

The black value for the color to be created.


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/wcs/basic-color-management-concepts">Basic Color Management Concepts</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-getcvalue">GetCValue</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-getkvalue">GetKValue</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-getmvalue">GetMValue</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-getyvalue">GetYValue</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/wcs/macros-for-cmyk-values-and-colors">Macros for CMYK Values and Colors</a>
 

 

