---
UID: NF:wingdi.GetBValue
title: GetBValue macro (wingdi.h)
description: The GetBValue macro retrieves an intensity value for the blue component of a red, green, blue (RGB) value.
old-location: gdi\getbvalue.htm
tech.root: gdi
ms.assetid: 97e2644c-5298-4dea-b35a-fc0e2c74f9c8
ms.date: 12/05/2018
ms.keywords: GetBValue, GetBValue macro [Windows GDI], _win32_GetBValue, gdi.getbvalue, wingdi/GetBValue
f1_keywords:
- wingdi/GetBValue
dev_langs:
- c++
req.header: wingdi.h
req.include-header: Windows.h
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Wingdi.h
api_name:
- GetBValue
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# GetBValue macro


## -description



The <b>GetBValue</b> macro retrieves an intensity value for the blue component of a red, green, blue (RGB) value.




## -parameters




### -param rgb

Specifies an RGB color value.


## -remarks



The intensity value is in the range 0 through 255.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/gdi/color-macros">Color Macros</a>



<a href="https://docs.microsoft.com/windows/desktop/gdi/colors">Colors Overview</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-getgvalue">GetGValue</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-getrvalue">GetRValue</a>



<a href="https://docs.microsoft.com/previous-versions/dd162770(v=vs.85)">PALETTEINDEX</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-palettergb">PALETTERGB</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-rgb">RGB</a>
 

 

