---
UID: NF:wingdi.GetKValue
title: GetKValue macro (wingdi.h)
description: The GetKValue macro retrieves the black color value from a CMYK color value.
old-location: wcs\getkvalue.htm
tech.root: WCS
ms.assetid: 8015689c-920c-4896-a34f-cda4f9b187e1
ms.date: 12/05/2018
ms.keywords: GetKValue, GetKValue macro [Windows Color System], _color_GetKValue, wcs.getkvalue, wingdi/GetKValue
f1_keywords:
- wingdi/GetKValue
dev_langs:
- c++
req.header: wingdi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Wingdi.h
api_name:
- GetKValue
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# GetKValue macro


## -description



The <b>GetKValue</b> macro retrieves the black color value from a CMYK color value.




## -parameters




### -param cmyk

CMYK color value from which the black color value will be retrieved.


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/wcs/basic-color-management-concepts">Basic Color Management Concepts</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-cmyk">CMYK</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-getcvalue">GetCValue</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-getmvalue">GetMValue</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-getyvalue">GetYValue</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/wcs/macros-for-cmyk-values-and-colors">Macros for CMYK Values and Colors</a>
 

 

