---
UID: NF:wingdi.GetMValue
title: GetMValue macro (wingdi.h)
description: The GetMValue macro retrieves the magenta color value from a CMYK color value.
old-location: wcs\getmvalue.htm
tech.root: WCS
ms.assetid: d24816de-a3c7-4d9f-b6a0-652330cd3ccd
ms.date: 12/05/2018
ms.keywords: GetMValue, GetMValue macro [Windows Color System], _color_GetMValue, wcs.getmvalue, wingdi/GetMValue
f1_keywords:
- wingdi/GetMValue
dev_langs:
- c++
req.header: wingdi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Wingdi.h
api_name:
- GetMValue
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# GetMValue macro


## -description



The <b>GetMValue</b> macro retrieves the magenta color value from a CMYK color value.




## -parameters




### -param cmyk

CMYK color value from which the magenta color value will be retrieved.


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/wcs/basic-color-management-concepts">Basic Color Management Concepts</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-cmyk">CMYK</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-getcvalue">GetCValue</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-getkvalue">GetKValue</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-getyvalue">GetYValue</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/wcs/macros-for-cmyk-values-and-colors">Macros for CMYK Values and Colors</a>
 

 

