---
UID: NS:wingdi.tagICEXYZTRIPLE
title: CIEXYZTRIPLE (wingdi.h)
description: The CIEXYZTRIPLE structure contains the x,y, and z coordinates of the three colors that correspond to the red, green, and blue endpoints for a specified logical color space.
old-location: wcs\ciexyztriple.htm
tech.root: WCS
ms.assetid: cf4473b0-7e54-42d1-a013-2442a540daee
ms.date: 12/05/2018
ms.keywords: '*LPCIEXYZTRIPLE, CIEXYZTRIPLE, CIEXYZTRIPLE structure [Windows Color System], CIEXYZTRIPLE typedef CIEXYZTRIPLE FAR* LPCIEXYZTRIPLE, CIEXYZTRIPLE typedef CIEXYZTRIPLE FAR* LPCIEXYZTRIPLE structure [Windows Color System], _color_CIEXYZTRIPLE_str, wcs.ciexyztriple, wingdi/CIEXYZTRIPLE'
f1_keywords:
- wingdi/CIEXYZTRIPLE typedef CIEXYZTRIPLE FAR* LPCIEXYZTRIPLE
dev_langs:
- c++
req.header: wingdi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Wingdi.h
api_name:
- CIEXYZTRIPLE typedef CIEXYZTRIPLE FAR* LPCIEXYZTRIPLE
targetos: Windows
req.typenames: CIEXYZTRIPLE
req.redist: 
ms.custom: 19H1
---

# CIEXYZTRIPLE structure


## -description



The <b>CIEXYZTRIPLE</b> structure contains the <i>x</i>,<i>y</i>, and <i>z</i> coordinates of the three colors that correspond to the red, green, and blue endpoints for a specified logical color space.




## -struct-fields




### -field ciexyzRed

The xyz coordinates of red endpoint.


### -field ciexyzGreen

The xyz coordinates of green endpoint.


### -field ciexyzBlue

The xyz coordinates of blue endpoint.


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/wcs/basic-color-management-concepts">Basic Color Management Concepts</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/wcs/structures">Structures</a>
 

 

