---
UID: NS:wingdi.tagEMRGLSBOUNDEDRECORD
title: EMRGLSBOUNDEDRECORD (wingdi.h)
description: The EMRGLSBOUNDEDRECORD structure contains members for an enhanced metafile record generated by OpenGL functions. It contains data for OpenGL functions with information in pixel units that must be scaled when playing the metafile.
old-location: gdi\emrglsboundedrecord.htm
tech.root: gdi
ms.assetid: 0e397451-543c-4278-9cdd-fbd276b646dd
ms.date: 12/05/2018
ms.keywords: '*PEMRGLSBOUNDEDRECORD, EMRGLSBOUNDEDRECORD, EMRGLSBOUNDEDRECORD structure [Windows GDI], PEMRGLSBOUNDEDRECORD, PEMRGLSBOUNDEDRECORD structure pointer [Windows GDI], _win32_EMRGLSBOUNDEDRECORD_str, gdi.emrglsboundedrecord, wingdi/EMRGLSBOUNDEDRECORD, wingdi/PEMRGLSBOUNDEDRECORD'
f1_keywords:
- wingdi/EMRGLSBOUNDEDRECORD
dev_langs:
- c++
req.header: wingdi.h
req.include-header: Windows.h
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Wingdi.h
api_name:
- EMRGLSBOUNDEDRECORD
targetos: Windows
req.typenames: EMRGLSBOUNDEDRECORD, *PEMRGLSBOUNDEDRECORD
req.redist: 
ms.custom: 19H1
---

# EMRGLSBOUNDEDRECORD structure


## -description



The <b>EMRGLSBOUNDEDRECORD</b> structure contains members for an enhanced metafile record generated by OpenGL functions. It contains data for OpenGL functions with information in pixel units that must be scaled when playing the metafile.




## -struct-fields




### -field emr

The base structure for all record types.


### -field rclBounds

Bounds of the rectangle, in device coordinates, within which to perform the OpenGL function. For more information, see Remarks.


### -field cbData

Size of <i>Data</i>, in bytes.


### -field Data

Array of data representing the OpenGL function to be performed.


## -remarks



The coordinates in <b>rclBounds</b> are in OpenGL pixel coordinates, which generally equate to window coordinates. 
		For example, if the <a href="https://docs.microsoft.com/windows/desktop/OpenGL/glbitmap">glBitmap</a> function has width1 and height1, the bounds will be 0, 0, width1, height1.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/gdi/metafile-structures">Metafile Structures</a>



<a href="https://docs.microsoft.com/windows/desktop/gdi/metafiles">Metafiles Overview</a>



<a href="https://docs.microsoft.com/windows/desktop/OpenGL/opengl-on-windows-nt--windows-2000--and-windows-95-98">OpenGL on Windows NT, Windows 2000, and Windows 95/98</a>
 

 

