---
UID: NS:wingdi.tagEMRGLSRECORD
title: EMRGLSRECORD (wingdi.h)
description: The EMRGLSRECORD structure contains members for an enhanced metafile record generated by OpenGL functions. It contains data for OpenGL functions that scale automatically to the OpenGL viewport.
old-location: gdi\emrglsrecord.htm
tech.root: gdi
ms.assetid: 58e31199-80e2-4077-a6f6-1787c5228f77
ms.date: 12/05/2018
ms.keywords: '*PEMRGLSRECORD, EMRGLSRECORD, EMRGLSRECORD structure [Windows GDI], PEMRGLSRECORD, PEMRGLSRECORD structure pointer [Windows GDI], _win32_EMRGLSRECORD_str, gdi.emrglsrecord, wingdi/EMRGLSRECORD, wingdi/PEMRGLSRECORD'
f1_keywords:
- wingdi/EMRGLSRECORD
dev_langs:
- c++
req.header: wingdi.h
req.include-header: Windows.h
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Wingdi.h
api_name:
- EMRGLSRECORD
targetos: Windows
req.typenames: EMRGLSRECORD, *PEMRGLSRECORD
req.redist: 
ms.custom: 19H1
---

# EMRGLSRECORD structure


## -description



The <b>EMRGLSRECORD</b> structure contains members for an enhanced metafile record generated by OpenGL functions. 
		  It contains data for OpenGL functions that scale automatically to the OpenGL viewport.




## -struct-fields




### -field emr

The base structure for all records.


### -field cbData

Size of <b>Data</b>, in bytes.


### -field Data

Array of data representing the OpenGL function to be performed.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/gdi/metafile-structures">Metafile Structures</a>



<a href="https://docs.microsoft.com/windows/desktop/gdi/metafiles">Metafiles Overview</a>



<a href="https://docs.microsoft.com/windows/desktop/OpenGL/opengl-on-windows-nt--windows-2000--and-windows-95-98">OpenGL on Windows NT, Windows 2000, and Windows 95/98</a>
 

 

