---
UID: NS:wingdi.tagEMRSELECTCLIPPATH
title: EMRSELECTCLIPPATH (wingdi.h)
description: Contains parameters for the SelectClipPath, SetBkMode, SetMapMode, SetPolyFillMode, SetROP2, SetStretchBltMode, SetTextAlign, SetICMMode , and SetLayout enhanced metafile records.
old-location: gdi\enhanced_metafile_records_with_one_parameter.htm
tech.root: gdi
ms.assetid: cae5eb68-169e-4439-9141-af93c8ff5ec6
ms.date: 12/05/2018
ms.keywords: '#if(WINVER >= 0x0500) EMRSETLAYOUT, #if(WINVER >= 0x0500) EMRSETLAYOUT structure [Windows GDI], *PEMRSELECTCLIPPATH, *PEMRSETBKMODE, *PEMRSETICMMODE, *PEMRSETLAYOUT, *PEMRSETMAPMODE, *PEMRSETPOLYFILLMODE, *PEMRSETROP2, *PEMRSETSTRETCHBLTMODE, *PEMRSETTEXTALIGN, EMRSELECTCLIPPATH, EMRSELECTCLIPPATH structure [Windows GDI], EMRSETBKMODE, EMRSETBKMODE structure [Windows GDI], EMRSETICMMODE, EMRSETICMMODE structure [Windows GDI], EMRSETLAYOUT, EMRSETMAPMODE, EMRSETMAPMODE structure [Windows GDI], EMRSETPOLYFILLMODE, EMRSETPOLYFILLMODE structure [Windows GDI], EMRSETROP2, EMRSETROP2 structure [Windows GDI], EMRSETSTRETCHBLTMODE, EMRSETSTRETCHBLTMODE structure [Windows GDI], EMRSETTEXTALIGN, EMRSETTEXTALIGN structure [Windows GDI], Enhanced Metafile Records with One Parameter, Enhanced Metafile Records with One Parameter structure [Windows GDI], PEMRSELECTCLIPPATH, PEMRSELECTCLIPPATH structure pointer [Windows GDI], PEMRSETBKMODE, PEMRSETBKMODE structure pointer [Windows GDI], PEMRSETICMMODE, PEMRSETICMMODE structure pointer [Windows GDI], PEMRSETLAYOUT #endif / WINVER >= 0x0500 /, PEMRSETLAYOUT #endif / WINVER >= 0x0500 / structure pointer [Windows GDI], PEMRSETMAPMODE, PEMRSETMAPMODE structure pointer [Windows GDI], PEMRSETPOLYFILLMODE, PEMRSETPOLYFILLMODE structure pointer [Windows GDI], PEMRSETROP2, PEMRSETROP2 structure pointer [Windows GDI], PEMRSETSTRETCHBLTMODE, PEMRSETSTRETCHBLTMODE structure pointer [Windows GDI], PEMRSETTEXTALIGN, PEMRSETTEXTALIGN structure pointer [Windows GDI], _win32_Enhanced_Metafile_Records_with_One_Parameter_str, gdi.enhanced_metafile_records_with_one_parameter, wingdi/#if(WINVER >= 0x0500) EMRSETLAYOUT, wingdi/EMRSETBKMODE, wingdi/EMRSETICMMODE, wingdi/EMRSETMAPMODE, wingdi/EMRSETPOLYFILLMODE, wingdi/EMRSETROP2, wingdi/EMRSETSTRETCHBLTMODE, wingdi/EMRSETTEXTALIGN, wingdi/Enhanced Metafile Records with One Parameter, wingdi/PEMRSELECTCLIPPATH, wingdi/PEMRSETBKMODE, wingdi/PEMRSETICMMODE, wingdi/PEMRSETLAYOUT #endif / WINVER >= 0x0500 /, wingdi/PEMRSETMAPMODE, wingdi/PEMRSETPOLYFILLMODE, wingdi/PEMRSETROP2, wingdi/PEMRSETSTRETCHBLTMODE, wingdi/PEMRSETTEXTALIGN'
f1_keywords:
- wingdi/EMRSELECTCLIPPATH
dev_langs:
- c++
req.header: wingdi.h
req.include-header: Windows.h
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Wingdi.h
api_name:
- EMRSELECTCLIPPATH
targetos: Windows
req.typenames: EMRSELECTCLIPPATH, *PEMRSELECTCLIPPATH, EMRSETBKMODE, *PEMRSETBKMODE, EMRSETMAPMODE, *PEMRSETMAPMODE, EMRSETLAYOUT, *PEMRSETLAYOUT, EMRSETPOLYFILLMODE, *PEMRSETPOLYFILLMODE, EMRSETROP2, *PEMRSETROP2, EMRSETSTRETCHBLTMODE, *PEMRSETSTRETCHBLTMODE, EMRSETICMMODE, *PEMRSETICMMODE, EMRSETTEXTALIGN, *PEMRSETTEXTALIGN
req.redist: 
ms.custom: 19H1
---

# EMRSELECTCLIPPATH structure


## -description



Contains parameters for the <a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-selectclippath">SelectClipPath</a>, <a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-setbkmode">SetBkMode</a>, <a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-setmapmode">SetMapMode</a>, <a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-setpolyfillmode">SetPolyFillMode</a>, <a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-setrop2">SetROP2</a>, <a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-setstretchbltmode">SetStretchBltMode</a>, <a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-settextalign">SetTextAlign</a>, <a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-seticmmode">SetICMMode</a> , and <a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-setlayout">SetLayout</a> enhanced metafile records.




## -struct-fields




### -field emr

The base structure for all record types.


### -field iMode

A value and meaning that varies depending on the function contained in the enhanced metafile record. For a description of this member, see the documentation of the functions contained in this record.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/gdi/metafile-structures">Metafile Structures</a>



<a href="https://docs.microsoft.com/windows/desktop/gdi/metafiles">Metafiles Overview</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-selectclippath">SelectClipPath</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-setbkmode">SetBkMode</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-seticmmode">SetICMMode</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-setmapmode">SetMapMode</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-setpolyfillmode">SetPolyFillMode</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-setrop2">SetROP2</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-setstretchbltmode">SetStretchBltMode</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-settextalign">SetTextAlign</a>
 

 

