---
UID: NS:wingdi._POINTFLOAT
title: POINTFLOAT (wingdi.h)
description: The POINTFLOAT structure contains the x and y coordinates of a point.
old-location: opengl\pointfloat.htm
tech.root: OpenGL
ms.assetid: 9cb57d32-386a-4554-9f47-62d5c4e2ee4e
ms.date: 12/05/2018
ms.keywords: '*PPOINTFLOAT, POINTFLOAT, POINTFLOAT structure [OpenGL], PPOINTFLOAT, PPOINTFLOAT structure pointer [OpenGL], _ogl_POINTFLOAT, opengl.pointfloat, wingdi/POINTFLOAT, wingdi/PPOINTFLOAT'
f1_keywords:
- wingdi/POINTFLOAT
dev_langs:
- c++
req.header: wingdi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- wingdi.h
api_name:
- POINTFLOAT
targetos: Windows
req.typenames: POINTFLOAT, *PPOINTFLOAT
req.redist: 
ms.custom: 19H1
---

# POINTFLOAT structure


## -description



The <b>POINTFLOAT</b> structure contains the x and y coordinates of a point.




## -struct-fields




### -field x

Specifies the horizontal (x) coordinate of a point.


### -field y

Specifies the vertical (y) coordinate of a point.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/wingdi/ns-wingdi-glyphmetricsfloat">GLYPHMETRICSFLOAT</a>



<a href="https://docs.microsoft.com/windows/desktop/OpenGL/opengl-on-windows-nt--windows-2000--and-windows-95-98">OpenGL on Windows</a>



<a href="https://docs.microsoft.com/windows/desktop/OpenGL/structures">Structures</a>
 

 

