---
UID: NF:wininet.FtpRenameFileW
title: FtpRenameFileW function (wininet.h)
description: Renames a file stored on the FTP server.
old-location: wininet\ftprenamefile.htm
tech.root: wininet
ms.assetid: 2c46d8bb-aceb-4dd2-be4f-2c418357d4ae
ms.date: 12/05/2018
ms.keywords: FtpRenameFile, FtpRenameFile function [WinINet], FtpRenameFileA, FtpRenameFileW, _inet_ftprenamefile_function, wininet.ftprenamefile, wininet/FtpRenameFile, wininet/FtpRenameFileA, wininet/FtpRenameFileW
f1_keywords:
- wininet/FtpRenameFile
dev_langs:
- c++
req.header: wininet.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: FtpRenameFileW (Unicode) and FtpRenameFileA (ANSI)
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Wininet.lib
req.dll: Wininet.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Wininet.dll
api_name:
- FtpRenameFile
- FtpRenameFileA
- FtpRenameFileW
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# FtpRenameFileW function


## -description


Renames a file stored on the FTP server.


## -parameters




### -param hConnect [in]

Handle to an FTP session.


### -param lpszExisting [in]

Pointer to a null-terminated string that contains the name of the file to be renamed.


### -param lpszNew [in]

Pointer to a null-terminated string that contains the new name for the remote file.


## -returns



Returns <b>TRUE</b> if successful, or <b>FALSE</b> otherwise. To get a specific error message, call 
<a href="https://docs.microsoft.com/windows/desktop/api/errhandlingapi/nf-errhandlingapi-getlasterror">GetLastError</a>.




## -remarks



The 
<i>lpszExisting</i> and 
<i>lpszNew</i> parameters can be either partially or fully qualified file names relative to the current directory.

Like all other aspects of the WinINet API, this function cannot be safely called from within DllMain or the constructors and destructors of global objects.

<div class="alert"><b>Note</b>  WinINet does not support server implementations. In addition, it should not be used from a service.  For server implementations or services use <a href="https://docs.microsoft.com/windows/desktop/WinHttp/winhttp-start-page">Microsoft Windows HTTP Services (WinHTTP)</a>.</div>
<div> </div>



## -see-also




<a href="https://docs.microsoft.com/windows/desktop/WinInet/ftp-sessions">FTP Sessions</a>



<a href="https://docs.microsoft.com/windows/desktop/WinInet/wininet-functions"> WinINet Functions</a>
 

 

