---
UID: NF:wininet.InternetOpenUrlW
title: InternetOpenUrlW function (wininet.h)
description: Opens a resource specified by a complete FTP or HTTP URL.
old-location: wininet\internetopenurl.htm
tech.root: wininet
ms.assetid: 73f969c3-3fa7-43f5-88c5-ba78e59a8d1c
ms.date: 12/05/2018
ms.keywords: InternetOpenUrl, InternetOpenUrl function [WinINet], InternetOpenUrlA, InternetOpenUrlW, _inet_internetopenurl_function, wininet.internetopenurl, wininet/InternetOpenUrl, wininet/InternetOpenUrlA, wininet/InternetOpenUrlW
f1_keywords:
- wininet/InternetOpenUrl
dev_langs:
- c++
req.header: wininet.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: InternetOpenUrlW (Unicode) and InternetOpenUrlA (ANSI)
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Wininet.lib
req.dll: Wininet.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Wininet.dll
api_name:
- InternetOpenUrl
- InternetOpenUrlA
- InternetOpenUrlW
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# InternetOpenUrlW function


## -description


Opens a resource specified by a complete FTP or HTTP URL.


## -parameters




### -param hInternet [in]

The handle to the current Internet session. The handle must have been returned by a previous call to 
<a href="https://docs.microsoft.com/windows/desktop/api/wininet/nf-wininet-internetopena">InternetOpen</a>.


### -param lpszUrl [in]

A pointer to a <b>null</b>-terminated string variable that specifies the URL to begin reading. Only URLs beginning with ftp:, http:, or https: are supported.


### -param lpszHeaders [in]

A pointer to a <b>null</b>-terminated string  that specifies the headers to be sent to the HTTP server. For more information, see the description of the 
<i>lpszHeaders</i> parameter in the 
<a href="https://docs.microsoft.com/windows/desktop/api/wininet/nf-wininet-httpsendrequesta">HttpSendRequest</a> function.


### -param dwHeadersLength [in]

The size of the additional headers, in <b>TCHARs</b>. If this parameter is -1L and 
<i>lpszHeaders</i> is not <b>NULL</b>, 
<i>lpszHeaders</i> is assumed to be zero-terminated (ASCIIZ) and the length is calculated.


### -param dwFlags [in]

This parameter can be one of the following values.

<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt>INTERNET_FLAG_EXISTING_CONNECT</dt>
</dl>
</td>
<td width="60%">
Attempts to use an existing InternetConnect object if one exists with the same attributes required to make the request. This is useful only with FTP operations, since FTP is the only protocol that typically performs multiple operations during the same session. The WinINet API caches a single connection handle for each <b>HINTERNET</b> handle generated by <a href="https://docs.microsoft.com/windows/desktop/api/wininet/nf-wininet-internetopena">InternetOpen</a>.  <b>InternetOpenUrl</b>   uses this flag for HTTP and FTP connections.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt>INTERNET_FLAG_HYPERLINK</dt>
</dl>
</td>
<td width="60%">
Forces a reload if there was no Expires time and no LastModified time returned from the server when determining whether to reload the item from the network.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt>INTERNET_FLAG_IGNORE_CERT_CN_INVALID</dt>
</dl>
</td>
<td width="60%">
Disables checking of SSL/PCT-based certificates that are returned from the server against the host name given in the request. WinINet functions use a simple check against certificates by comparing for matching host names and simple wildcarding rules.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt>INTERNET_FLAG_IGNORE_CERT_DATE_INVALID</dt>
</dl>
</td>
<td width="60%">
Disables checking of SSL/PCT-based certificates for proper validity dates.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt>INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTP</dt>
</dl>
</td>
<td width="60%">
Disables detection of this special type of redirect. When this flag is used, WinINet transparently allows redirects from HTTPS to HTTP URLs.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt>INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTPS</dt>
</dl>
</td>
<td width="60%">
Disables the detection of this special type of redirect. When this flag is used, WinINet transparently allows redirects from HTTP to HTTPS URLs.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt>INTERNET_FLAG_KEEP_CONNECTION</dt>
</dl>
</td>
<td width="60%">
Uses keep-alive semantics, if available, for the connection. This flag is required for Microsoft Network (MSN), NTLM, and other types of authentication.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt>INTERNET_FLAG_NEED_FILE</dt>
</dl>
</td>
<td width="60%">
Causes a temporary file to be created if the file cannot be cached.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt>INTERNET_FLAG_NO_AUTH</dt>
</dl>
</td>
<td width="60%">
Does not attempt authentication automatically.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt>INTERNET_FLAG_NO_AUTO_REDIRECT</dt>
</dl>
</td>
<td width="60%">
Does not automatically handle redirection in 
<a href="https://docs.microsoft.com/windows/desktop/api/wininet/nf-wininet-httpsendrequesta">HttpSendRequest</a>.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt>INTERNET_FLAG_NO_CACHE_WRITE</dt>
</dl>
</td>
<td width="60%">
Does not add the returned entity to the cache.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt>INTERNET_FLAG_NO_COOKIES</dt>
</dl>
</td>
<td width="60%">
Does not automatically add cookie headers to requests, and does not automatically add returned cookies to the cookie database.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt>INTERNET_FLAG_NO_UI</dt>
</dl>
</td>
<td width="60%">
Disables the cookie dialog box.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt>INTERNET_FLAG_PASSIVE</dt>
</dl>
</td>
<td width="60%">
Uses passive FTP semantics. 
<b>InternetOpenUrl</b> uses this flag for FTP files and directories. 

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt>INTERNET_FLAG_PRAGMA_NOCACHE</dt>
</dl>
</td>
<td width="60%">
Forces the request to be resolved by the origin server, even if a cached copy exists on the proxy.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt>INTERNET_FLAG_RAW_DATA</dt>
</dl>
</td>
<td width="60%">
Returns the data as a 
<a href="https://docs.microsoft.com/windows/desktop/api/minwinbase/ns-minwinbase-win32_find_dataa">WIN32_FIND_DATA</a> structure when retrieving FTP directory information. If this flag is not specified or if the call was made through a CERN proxy, 
<b>InternetOpenUrl</b> returns the HTML version of the directory. 

<b>Windows XP and Windows Server 2003 R2 and earlier:  </b>Also returns data as a <a href="https://docs.microsoft.com/windows/desktop/api/wininet/ns-wininet-gopher_find_dataa">GOPHER_FIND_DATA</a> structure when retrieving Gopher directory information.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt>INTERNET_FLAG_RELOAD</dt>
</dl>
</td>
<td width="60%">
Forces a download of the requested file, object, or directory listing from the origin server, not from the cache.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt>INTERNET_FLAG_RESYNCHRONIZE</dt>
</dl>
</td>
<td width="60%">
Reloads HTTP resources if the resource has been modified since the last time it was downloaded. All FTP resources are reloaded.

<b>Windows XP and Windows Server 2003 R2 and earlier:  </b>Gopher resources are also reloaded.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt>INTERNET_FLAG_SECURE</dt>
</dl>
</td>
<td width="60%">
Uses secure transaction semantics. This translates to using Secure Sockets Layer/Private Communications Technology (SSL/PCT) and is only meaningful in HTTP requests.

</td>
</tr>
</table>
 


### -param dwContext [in]

A pointer to a variable that specifies the application-defined value that is passed, along with the returned handle, to any callback functions.


## -returns



Returns a valid handle to the URL if the connection is successfully established, or <b>NULL</b> if the connection fails. To retrieve a specific error message, call 
<a href="https://docs.microsoft.com/windows/desktop/api/errhandlingapi/nf-errhandlingapi-getlasterror">GetLastError</a>. To determine why access to the service was denied, call 
<a href="https://docs.microsoft.com/windows/desktop/api/wininet/nf-wininet-internetgetlastresponseinfoa">InternetGetLastResponseInfo</a>.




## -remarks



Call 
<a href="https://docs.microsoft.com/windows/desktop/api/wininet/nf-wininet-internetcanonicalizeurla">InternetCanonicalizeUrl</a> first if the URL being used contains a relative URL and a base URL separated by blank spaces.

This is a general function that an application can use to retrieve data over any of the protocols that WinINet supports. This function is especially useful when the application does not need to access the particulars of a protocol, but only requires the data corresponding to a URL. The 
<b>InternetOpenUrl</b> function parses the URL string, establishes a connection to the server, and prepares to download the data identified by the URL. The application can then use 
<a href="https://docs.microsoft.com/windows/desktop/api/wininet/nf-wininet-internetreadfile">InternetReadFile</a> (for files) or 
<a href="https://docs.microsoft.com/windows/desktop/api/wininet/nf-wininet-internetfindnextfilea">InternetFindNextFile</a> (for directories) to retrieve the URL data. It is not necessary to call 
<a href="https://docs.microsoft.com/windows/desktop/api/wininet/nf-wininet-internetconnecta">InternetConnect</a> before 
<b>InternetOpenUrl</b>.

<b>Windows XP and Windows Server 2003 R2 and earlier:  </b><b>InternetOpenUrl</b> disables Gopher on ports less than 1024, except for port 70—the standard Gopher port—and port 105—typically used for Central Services Organization (CSO) name searches.

After the calling application has finished using the 
<a href="https://docs.microsoft.com/windows/desktop/WinInet/appendix-a-hinternet-handles">HINTERNET</a> handle returned by 
<b>InternetOpenUrl</b>, it must be closed using the 
<a href="https://docs.microsoft.com/windows/desktop/api/wininet/nf-wininet-internetclosehandle">InternetCloseHandle</a> function.

<b>Note</b>  When working in asynchronous mode (the <i>dwFlags</i> parameter of <a href="https://docs.microsoft.com/windows/desktop/api/wininet/nf-wininet-internetopena">InternetOpen</a> specifies <b>INTERNET_FLAG_ASYNC</b>), and the <i>dwContext</i> parameter is zero (<b>INTERNET_NO_CALLBACK</b>), the callback function set with <a href="https://docs.microsoft.com/windows/desktop/api/wininet/nf-wininet-internetsetstatuscallback">InternetSetStatusCallback</a> on the session handle will not be invoked, however, the call will still be performed in asynchronous mode

Like all other aspects of the WinINet API, this function cannot be safely called from within DllMain or the constructors and destructors of global objects.

<div class="alert"><b>Note</b>  WinINet does not support server implementations. In addition, it should not be used from a service.  For server implementations or services use <a href="https://docs.microsoft.com/windows/desktop/WinHttp/winhttp-start-page">Microsoft Windows HTTP Services (WinHTTP)</a>.</div>
<div> </div>



## -see-also




<a href="https://docs.microsoft.com/windows/desktop/WinInet/handling-uniform-resource-locators">Handling Uniform Resource Locators</a>



<a href="https://docs.microsoft.com/windows/desktop/WinInet/wininet-functions">WinINet Functions</a>
 

 

