---
UID: NE:winioctl._STORAGE_MEDIA_TYPE
title: STORAGE_MEDIA_TYPE
description: Specifies various types of storage media.
old-location: base\storage_media_type.htm
tech.root: devio
ms.assetid: f584d766-0d4d-49b8-b58a-09556c494270
ms.date: 12/05/2018
ms.keywords: '*PSTORAGE_MEDIA_TYPE, ABL_5_WO, ADR_1, ADR_2, AIT1_8mm, AIT_8mm, AME_8mm, AVATAR_F2, CD_R, CD_ROM, CD_RW, CLEANER_CARTRIDGE, CYGNET_12_WO, DDS_4mm, DLT, DMI, DST_L, DST_M, DST_S, DVD_R, DVD_RAM, DVD_ROM, DVD_RW, DV_6mm, HITACHI_12_WO, IBM_3480, IBM_3490E, IBM_Magstar_3590, IBM_Magstar_MP, IOMEGA_JAZ, IOMEGA_ZIP, KODAK_14_WO, LTO_Accelis, LTO_Ultrium, MO_3_RW, MO_5_LIMDOW, MO_5_RW, MO_5_WO, MO_NFR_525, MP2_8mm, MP_8mm, MiniQic, NCTP, NIKON_12_RW, PC_5_RW, PC_5_WO, PD_5_RW, PHILIPS_12_WO, PINNACLE_APEX_5_RW, PSTORAGE_MEDIA_TYPE, PSTORAGE_MEDIA_TYPE enumeration pointer, QIC, SAIT, SONY_12_WO, SONY_D2, SONY_DTF, STK_9840, STK_9940, STK_DATA_D3, STORAGE_MEDIA_TYPE, STORAGE_MEDIA_TYPE enumeration, SYQUEST_EZ135, SYQUEST_EZFLYER, SYQUEST_SYJET, Travan, VXATape, VXATape_1, VXATape_2, _win32_storage_media_type, base.storage_media_type, winioctl/ABL_5_WO, winioctl/ADR_1, winioctl/ADR_2, winioctl/AIT1_8mm, winioctl/AIT_8mm, winioctl/AME_8mm, winioctl/AVATAR_F2, winioctl/CD_R, winioctl/CD_ROM, winioctl/CD_RW, winioctl/CLEANER_CARTRIDGE, winioctl/CYGNET_12_WO, winioctl/DDS_4mm, winioctl/DLT, winioctl/DMI, winioctl/DST_L, winioctl/DST_M, winioctl/DST_S, winioctl/DVD_R, winioctl/DVD_RAM, winioctl/DVD_ROM, winioctl/DVD_RW, winioctl/DV_6mm, winioctl/HITACHI_12_WO, winioctl/IBM_3480, winioctl/IBM_3490E, winioctl/IBM_Magstar_3590, winioctl/IBM_Magstar_MP, winioctl/IOMEGA_JAZ, winioctl/IOMEGA_ZIP, winioctl/KODAK_14_WO, winioctl/LTO_Accelis, winioctl/LTO_Ultrium, winioctl/MO_3_RW, winioctl/MO_5_LIMDOW, winioctl/MO_5_RW, winioctl/MO_5_WO, winioctl/MO_NFR_525, winioctl/MP2_8mm, winioctl/MP_8mm, winioctl/MiniQic, winioctl/NCTP, winioctl/NIKON_12_RW, winioctl/PC_5_RW, winioctl/PC_5_WO, winioctl/PD_5_RW, winioctl/PHILIPS_12_WO, winioctl/PINNACLE_APEX_5_RW, winioctl/PSTORAGE_MEDIA_TYPE, winioctl/QIC, winioctl/SAIT, winioctl/SONY_12_WO, winioctl/SONY_D2, winioctl/SONY_DTF, winioctl/STK_9840, winioctl/STK_9940, winioctl/STK_DATA_D3, winioctl/STORAGE_MEDIA_TYPE, winioctl/SYQUEST_EZ135, winioctl/SYQUEST_EZFLYER, winioctl/SYQUEST_SYJET, winioctl/Travan, winioctl/VXATape, winioctl/VXATape_1, winioctl/VXATape_2'
f1_keywords:
- winioctl/STORAGE_MEDIA_TYPE
dev_langs:
- c++
req.header: winioctl.h
req.include-header: Windows.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP
req.target-min-winversvr: Windows Server 2003
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- WinIoCtl.h
api_name:
- STORAGE_MEDIA_TYPE
targetos: Windows
req.typenames: STORAGE_MEDIA_TYPE, *PSTORAGE_MEDIA_TYPE
req.redist: 
---

# STORAGE_MEDIA_TYPE enumeration


## -description


Specifies various types of storage media. Parameters and members of type 
    <b>STORAGE_MEDIA_TYPE</b> also accept values from the 
    <a href="https://docs.microsoft.com/windows/desktop/api/winioctl/ne-winioctl-media_type">MEDIA_TYPE</a> enumeration type.


## -enum-fields




### -field DDS_4mm

One of the following tape types: DAT, DDS1, DDS2, and so on.


### -field MiniQic

MiniQIC tape.


### -field Travan

Travan tape (TR-1, TR-2, TR-3, and so on).


### -field QIC

QIC tape.


### -field MP_8mm

An 8mm Exabyte metal particle tape.


### -field AME_8mm

An 8mm Exabyte advanced metal evaporative tape.


### -field AIT1_8mm

An 8mm Sony AIT1 tape.


### -field DLT

DLT compact tape (IIIxt or IV).


### -field NCTP

Philips NCTP tape.


### -field IBM_3480

IBM 3480 tape.


### -field IBM_3490E

IBM 3490E tape.


### -field IBM_Magstar_3590

IBM Magstar 3590 tape.


### -field IBM_Magstar_MP

IBM Magstar MP tape.


### -field STK_DATA_D3

STK data D3 tape.


### -field SONY_DTF

Sony DTF tape.


### -field DV_6mm

A 6mm digital videotape.


### -field DMI

Exabyte DMI tape (or compatible).


### -field SONY_D2

Sony D2S or D2L tape.


### -field CLEANER_CARTRIDGE

Cleaner (all drive types that support cleaners).


### -field CD_ROM

CD.


### -field CD_R

CD (write once).


### -field CD_RW

CD (rewriteable).


### -field DVD_ROM

DVD.


### -field DVD_R

DVD (write once).


### -field DVD_RW

DVD (rewriteable).


### -field MO_3_RW

Magneto-optical 3.5" (rewriteable).


### -field MO_5_WO

Magneto-optical 5.25" (write once).


### -field MO_5_RW

Magneto-optical 5.25" (rewriteable; not LIMDOW).


### -field MO_5_LIMDOW

Magneto-optical 5.25" (rewriteable; LIMDOW).


### -field PC_5_WO

Phase change 5.25" (write once)


### -field PC_5_RW

Phase change 5.25" (rewriteable)


### -field PD_5_RW

Phase change dual (rewriteable)


### -field ABL_5_WO

Ablative 5.25" (write once).


### -field PINNACLE_APEX_5_RW

Pinnacle Apex 4.6GB (rewriteable)


### -field SONY_12_WO

Sony 12" (write once).


### -field PHILIPS_12_WO

Philips/LMS 12" (write once).


### -field HITACHI_12_WO

Hitachi 12" (write once)


### -field CYGNET_12_WO

Cygnet/ATG 12" (write once)


### -field KODAK_14_WO

Kodak 14" (write once)


### -field MO_NFR_525

MO near field recording (Terastor)


### -field NIKON_12_RW

Nikon 12" (rewriteable).


### -field IOMEGA_ZIP

Iomega Zip.


### -field IOMEGA_JAZ

Iomega Jaz.


### -field SYQUEST_EZ135

Syquest EZ135.


### -field SYQUEST_EZFLYER

Syquest EzFlyer.


### -field SYQUEST_SYJET

Syquest SyJet.


### -field AVATAR_F2

Avatar 2.5" floppy.


### -field MP2_8mm

An 8mm Hitachi tape.


### -field DST_S

Ampex DST small tape.


### -field DST_M

Ampex DST medium tape.


### -field DST_L

Ampex DST large tape.


### -field VXATape_1

Ecrix 8mm tape.


### -field VXATape_2

Ecrix 8mm tape.


### -field STK_EAGLE


### -field LTO_Ultrium

LTO Ultrium (IBM, HP, Seagate).


### -field LTO_Accelis

LTO Accelis (IBM, HP, Seagate).


### -field DVD_RAM

DVD-RAM.


### -field AIT_8mm

AIT tape (AIT2 or higher).


### -field ADR_1

OnStream ADR1.


### -field ADR_2

OnStream ADR2.


### -field STK_9940

STK 9940.


### -field SAIT

SAIT tape.

<b>Windows Server 2003:  </b>This is not supported before Windows Server 2003 with SP1.


### -field VXATape

Exabyte VXA tape.

<b>Windows Server 2008:  </b>This is not supported before Windows Server 2008.


#### - STK_9840

STK 9840.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/winioctl/ns-winioctl-device_media_info">DEVICE_MEDIA_INFO</a>



<a href="https://docs.microsoft.com/windows/desktop/api/winioctl/ne-winioctl-media_type">MEDIA_TYPE</a>



<a href="https://docs.microsoft.com/windows/desktop/api/ntmsapi/ns-ntmsapi-ntms_mediatypeinformation">NTMS_MEDIATYPEINFORMATION</a>
 

 

