---
UID: NS:winioctl._STORAGE_RPMB_DATA_FRAME
title: STORAGE_RPMB_DATA_FRAME
ms.date: 4/26/2019
ms.keywords: _STORAGE_RPMB_DATA_FRAME, STORAGE_RPMB_DATA_FRAME
f1_keywords:
- _STORAGE_RPMB_DATA_FRAME
dev_langs:
- c++
targetos: Windows
req.construct-type: structure
req.ddi-compliance: 
req.dll: 
req.header: winioctl.h
req.include-header: 
req.kmdf-ver: 
req.lib: 
req.max-support: 
req.redist: 
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.target-type: 
req.typenames: STORAGE_RPMB_DATA_FRAME, *PSTORAGE_RPMB_DATA_FRAME
req.umdf-ver: 
req.unicode-ansi: 
topic_type:
- apiref
api_type:
- HeaderDef
api_location:
- winioctl.h
api_name:
- _STORAGE_RPMB_DATA_FRAME
- STORAGE_RPMB_DATA_FRAME
---

## -description

Using the information from <a href="https://docs.microsoft.com/windows/desktop/api/winioctl/ni-winioctl-ioctl_storage_query_property.md">IOCTL_STORAGE_QUERY_PROPERTY</a>, an application can create an RPMB frame to perform one of the following actions:
•	Program Authentication Key
•	Query RPMB Write Counter
•	Authenticated Write
•	Authenticated Read
•	Authenticated Device Configuration Write
•	Authenticated Device Configuration Read


## -struct-fields

### -field Stuff

Reserved space.

### -field KeyOrMAC

Either the key to be programmed or the MAC authenticating this frame or series of frames.

### -field Data

The data input or output.

### -field Nonce

Random 128-bit number generated by host. Only required for reads.

### -field WriteCounter

32-bit counter. Only required for writes.

### -field Address

The half-sector address to operate on.

### -field BlockCount

The count of half-sector blocks to read/write.

### -field OperationResult

The result of the operation.

### -field RequestOrResponseType

The type of request or response.

## -remarks

## -see-also

