---
UID: NS:winioctl.__unnamed_struct_25
title: USN_RECORD_EXTENT
description: Contains the offset and length for an update sequence number (USN) record extent.
old-location: fs\usn_record_extent.htm
tech.root: FileIO
ms.assetid: 7D569FCB-06D4-4348-B75A-D087D1D37851
ms.date: 12/05/2018
ms.keywords: '*PUSN_RECORD_EXTENT, PUSN_RECORD_EXTENT, PUSN_RECORD_EXTENT structure pointer [Files], USN_RECORD_EXTENT, USN_RECORD_EXTENT structure [Files], fs.usn_record_extent, winioctl/PUSN_RECORD_EXTENT, winioctl/USN_RECORD_EXTENT'
f1_keywords:
- winioctl/USN_RECORD_EXTENT
dev_langs:
- c++
req.header: winioctl.h
req.include-header: Windows.h
req.target-type: Windows
req.target-min-winverclnt: Windows 8.1 [desktop apps only]
req.target-min-winversvr: Windows Server 2012 R2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- WinIoCtl.h
api_name:
- USN_RECORD_EXTENT
targetos: Windows
req.typenames: USN_RECORD_EXTENT, *PUSN_RECORD_EXTENT
req.redist: 
---

# USN_RECORD_EXTENT structure


## -description


Contains the offset and length for an update sequence number (USN) record extent.


## -struct-fields




### -field Offset

The offset of the extent, in bytes.


### -field Length

The length of the extent, in bytes. 


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/winioctl/ns-winioctl-usn_record_v4">USN_RECORD_V4</a>



<a href="https://docs.microsoft.com/windows/desktop/FileIO/volume-management-structures">Volume Management Structures</a>
 

 

