---
UID: NF:winldap.ldap_parse_extended_resultW
title: ldap_parse_extended_resultW function (winldap.h)
description: The ldap_parse_extended_result parses the results of an LDAP extended operation.
old-location: ldap\ldap_parse_extended_result.htm
tech.root: ldap
ms.assetid: b869c8e9-022c-437c-ba06-cb98a59c8c2d
ms.date: 12/05/2018
ms.keywords: _ldap_ldap_parse_extended_result, ldap.ldap__parse__extended__result, ldap.ldap_parse_extended_result, ldap_parse_extended_result, ldap_parse_extended_result function [LDAP], ldap_parse_extended_resultA, ldap_parse_extended_resultW, winldap/ldap_parse_extended_result, winldap/ldap_parse_extended_resultA, winldap/ldap_parse_extended_resultW
f1_keywords:
- winldap/ldap_parse_extended_result
dev_langs:
- c++
req.header: winldap.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista
req.target-min-winversvr: Windows Server 2008
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: ldap_parse_extended_resultW (Unicode) and ldap_parse_extended_resultA (ANSI)
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Wldap32.lib
req.dll: Wldap32.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Wldap32.dll
api_name:
- ldap_parse_extended_result
- ldap_parse_extended_resultA
- ldap_parse_extended_resultW
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# ldap_parse_extended_resultW function


## -description


The <b>ldap_parse_extended_result</b> parses the results of an LDAP extended operation.


## -parameters




### -param Connection [in]

The session handle.


### -param ResultMessage [in]

A pointer to an 
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/winldap/ns-winldap-ldapmessage">LDAPMessage</a> structure as returned by 
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/winldap/nf-winldap-ldap_result">ldap_result</a> in response to an extended operation request.


### -param ResultOID [out]

A pointer to a null-terminated string that contains the dotted object identifier (OID) text string of the server's response message.  This is normally the same OID as the one naming the request that was originally passed to the server by 
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/winldap/nf-winldap-ldap_extended_operation">ldap_extended_operation</a>.


### -param ResultData [out]

The arbitrary data returned by the extended operation (if <b>NULL</b>, no data is returned by the server).


### -param Freeit [in]

Determines whether the <i>ResultMessage</i> parameter is freed. You can pass any nonzero value to the <i>Freeit</i> parameter to free the <i>ResultMessage</i> pointer when it is no longer needed, or you can call 
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/winldap/nf-winldap-ldap_msgfree">ldap_msgfree</a> to free the result later.


## -returns



If the function succeeds, the return value is <b>LDAP_SUCCESS</b>.

If the function fails, it returns an error code. See 
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/ldap/return-values">Return Values</a> for more information.




## -remarks



When a server processes an extended operation request generated by 
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/winldap/nf-winldap-ldap_extended_operation">ldap_extended_operation</a>, it returns an LDAP message along with an <b>LDAP_RES_EXTENDED</b> return code. Use <b>ldap_parse_extended_result</b> to parse this result message, which returns both the text OID of the originating message in <i>ResultOID</i> and any arbitrary data generated by the extended operation in <i>ResultData</i>.

When they are no longer needed, free the <i>ResultOID</i> string and the <i>ResultData</i> buffer by calling 
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/winldap/nf-winldap-ldap_memfree">ldap_memfree</a>.




## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/ldap/functions">Functions</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/winldap/ns-winldap-ldapmessage">LDAPMessage</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/ldap/return-values">Return Values</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/winldap/nf-winldap-ldap_extended_operation">ldap_extended_operation</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/winldap/nf-winldap-ldap_memfree">ldap_memfree</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/winldap/nf-winldap-ldap_msgfree">ldap_msgfree</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/winldap/nf-winldap-ldap_result">ldap_result</a>
 

 

