---
UID: NE:winnls.SYSGEOCLASS
title: SYSGEOCLASS (winnls.h)
description: Specifies the geographical location class.
old-location: intl\sysgeoclass.htm
tech.root: Intl
ms.assetid: 27c2dec7-b5e7-47b7-8ce2-8dba3d0916bf
ms.date: 12/05/2018
ms.keywords: GEOCLASS_ALL, GEOCLASS_NATION, GEOCLASS_REGION, SYSGEOCLASS, SYSGEOCLASS enumeration [Internationalization for Windows Applications], _win32_SYSGEOCLASS, intl.sysgeoclass, winnls/GEOCLASS_ALL, winnls/GEOCLASS_NATION, winnls/GEOCLASS_REGION, winnls/SYSGEOCLASS
f1_keywords:
- winnls/SYSGEOCLASS
dev_langs:
- c++
req.header: winnls.h
req.include-header: Windows.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2003 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Winnls.h
api_name:
- SYSGEOCLASS
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# SYSGEOCLASS enumeration


## -description


Specifies the geographical location class.


## -enum-fields




### -field GEOCLASS_NATION

Class for nation geographical location identifiers.


### -field GEOCLASS_REGION

Class for region geographical location identifiers.


### -field GEOCLASS_ALL

<b>Starting with Windows 8:</b> Class for all geographical location identifiers.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/Intl/national-language-support-enumeration-types">National Language Support Enumeration Types</a>
 

 

