---
UID: NF:winnls.FILEMUIINFO_GET_CULTURE
title: FILEMUIINFO_GET_CULTURE macro (winnls.h)
description: Gets the locale name associated with the language name offset information in the dwLanguageNameOffset member of a FILEMUIINFO structure.
old-location: intl\filemuiinfo_get_culture.htm
tech.root: Intl
ms.assetid: 3afed0e8-3a9c-4513-954a-83855a53f5b2
ms.date: 12/05/2018
ms.keywords: FILEMUIINFO_GET_CULTURE, FILEMUIINFO_GET_CULTURE macro [Internationalization for Windows Applications], _win32_FILEMUIINFO_GET_CULTURE, intl.filemuiinfo_get_culture, winnls/FILEMUIINFO_GET_CULTURE
f1_keywords:
- winnls/FILEMUIINFO_GET_CULTURE
dev_langs:
- c++
req.header: winnls.h
req.include-header: Windows.h
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Winnls.h
api_name:
- FILEMUIINFO_GET_CULTURE
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# FILEMUIINFO_GET_CULTURE macro


## -description


Gets the locale name associated with the language name offset information in the <b>dwLanguageNameOffset</b> member of a <a href="https://docs.microsoft.com/windows/desktop/api/winnls/ns-winnls-filemuiinfo">FILEMUIINFO</a> structure.


## -parameters




### -param pInfo

Pointer to the <a href="https://docs.microsoft.com/windows/desktop/api/winnls/ns-winnls-filemuiinfo">FILEMUIINFO</a> structure.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/winnls/ns-winnls-filemuiinfo">FILEMUIINFO</a>



<a href="https://docs.microsoft.com/windows/desktop/Intl/multilingual-user-interface">Multilingual User Interface</a>



<a href="https://docs.microsoft.com/windows/desktop/Intl/multilingual-user-interface-macros">Multilingual User Interface Macros</a>
 

 

