---
UID: NF:winnls.FILEMUIINFO_GET_MUI_TYPEIDS
title: FILEMUIINFO_GET_MUI_TYPEIDS macro (winnls.h)
description: Gets the MUI module types array associated with the type identifier offset information in the dwTypeIDMUIOffset member of a FILEMUIINFO structure.
old-location: intl\filemuiinfo_get_mui_typeids.htm
tech.root: Intl
ms.assetid: 7f42e8e3-d308-4c2a-96c4-26df9f032211
ms.date: 12/05/2018
ms.keywords: FILEMUIINFO_GET_MUI_TYPEIDS, FILEMUIINFO_GET_MUI_TYPEIDS macro [Internationalization for Windows Applications], _win32_FILEMUIINFO_GET_MUI_TYPEIDS, intl.filemuiinfo_get_mui_typeids, winnls/FILEMUIINFO_GET_MUI_TYPEIDS
f1_keywords:
- winnls/FILEMUIINFO_GET_MUI_TYPEIDS
dev_langs:
- c++
req.header: winnls.h
req.include-header: Windows.h
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Winnls.h
api_name:
- FILEMUIINFO_GET_MUI_TYPEIDS
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# FILEMUIINFO_GET_MUI_TYPEIDS macro


## -description


Gets the MUI module types array associated with the type identifier offset information in the <b>dwTypeIDMUIOffset</b> member of a <a href="https://docs.microsoft.com/windows/desktop/api/winnls/ns-winnls-filemuiinfo">FILEMUIINFO</a> structure.


## -parameters




### -param pInfo

Pointer to the <a href="https://docs.microsoft.com/windows/desktop/api/winnls/ns-winnls-filemuiinfo">FILEMUIINFO</a> structure.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/winnls/ns-winnls-filemuiinfo">FILEMUIINFO</a>



<a href="https://docs.microsoft.com/windows/desktop/Intl/multilingual-user-interface">Multilingual User Interface</a>



<a href="https://docs.microsoft.com/windows/desktop/Intl/multilingual-user-interface-macros">Multilingual User Interface Macros</a>
 

 

