---
UID: NF:winnt.IsReparseTagNameSurrogate
title: IsReparseTagNameSurrogate macro (winnt.h)
description: Determines whether a tag's associated reparse point is a surrogate for another named entity (for example, a mounted folder).
old-location: fs\isreparsetagnamesurrogate.htm
tech.root: FileIO
ms.assetid: 6d79527a-0c78-42d2-b079-3eb487de295f
ms.date: 12/05/2018
ms.keywords: IsReparseTagNameSurrogate, IsReparseTagNameSurrogate macro [Files], _win32_isreparsetagnamesurrogate, base.isreparsetagnamesurrogate, fs.isreparsetagnamesurrogate, winnt/IsReparseTagNameSurrogate
f1_keywords:
- winnt/IsReparseTagNameSurrogate
dev_langs:
- c++
req.header: winnt.h
req.include-header: Windows.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Winnt.h
api_name:
- IsReparseTagNameSurrogate
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IsReparseTagNameSurrogate macro


## -description


Determines whether a tag's associated reparse point is a surrogate for another named entity (for example, a mounted folder).


## -parameters




### -param _tag

The reparse point tag to be tested for surrogacy.


## -remarks



If the surrogacy bit is set, the file or directory represents another named entity in the system, such as a mounted folder that associates this directory with another volume. For more information on volume mounting, see 
<a href="https://docs.microsoft.com/windows/desktop/FileIO/volume-mount-points">Mounted Folders</a>.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/winioctl/ni-winioctl-fsctl_get_reparse_point">FSCTL_GET_REPARSE_POINT</a>



<a href="https://docs.microsoft.com/windows/desktop/FileIO/reparse-points">Reparse Points</a>
 

 

