---
UID: NF:winnt.RtlAddFunctionTable
title: RtlAddFunctionTable function (winnt.h)
description: Adds a dynamic function table to the dynamic function table list.
old-location: base\rtladdfunctiontable.htm
tech.root: Debug
ms.assetid: 4717f29e-c5f8-4b02-a7c8-edd065f1c793
ms.date: 12/05/2018
ms.keywords: RtlAddFunctionTable, RtlAddFunctionTable function, base.rtladdfunctiontable, winnt/RtlAddFunctionTable
f1_keywords:
- winnt/RtlAddFunctionTable
dev_langs:
- c++
req.header: winnt.h
req.include-header: Windows.h
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Kernel32.lib
req.dll: Kernel32.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Kernel32.dll
- API-MS-Win-Core-rtlsupport-l1-1-0.dll
- ntdll.dll
- API-MS-Win-Core-rtlsupport-l1-2-0.dll
api_name:
- RtlAddFunctionTable
targetos: Windows
req.typenames: 
req.redist: 
req.product: Windows XP Professional x64 Edition or 64-bit editions of     Windows Server 2003
ms.custom: 19H1
---

# RtlAddFunctionTable function


## -description


Adds a dynamic function table to the dynamic function table list.


## -parameters




### -param FunctionTable [in]

A pointer to an array of function entries. For a definition of the 
       <b>PRUNTIME_FUNCTION</b> type, see WinNT.h. For more information on runtime 
       function entries, see the calling convention documentation for the processor.


### -param EntryCount [in]

The number of entries in the <i>FunctionTable</i> array.


### -param BaseAddress [in]

The base address to use when computing full virtual addresses from relative virtual addresses of function 
       table entries.


#### - TargetGp [in]

The target global pointer. This is part of the Intel IPF calling convention. It is a pointer to a data 
        area in an image.

This parameter does not exist on x64.


## -returns



If the function succeeds, the return value is <b>TRUE</b>. Otherwise, the return value 
       is <b>FALSE</b>.




## -remarks



Function tables are used on 64-bit Windows to determine how to unwind or walk the stack. These tables are 
    usually generated by the compiler and stored as part of the image. However, applications must provide the 
    function table for dynamically generated code. For more information about function tables, see the architecture 
    guide for your system.

This function is useful for code that is generated from a template or generated only once during the life of 
    the process. For more dynamically generated code, use the 
    <a href="https://docs.microsoft.com/windows/desktop/api/winnt/nf-winnt-rtlinstallfunctiontablecallback">RtlInstallFunctionTableCallback</a> 
    function.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/winnt/nf-winnt-rtldeletefunctiontable">RtlDeleteFunctionTable</a>



<a href="https://docs.microsoft.com/windows/desktop/api/winnt/nf-winnt-rtlinstallfunctiontablecallback">RtlInstallFunctionTableCallback</a>
 

 

