---
UID: NF:winnt.RtlDeleteFunctionTable
title: RtlDeleteFunctionTable function (winnt.h)
description: Removes a dynamic function table from the dynamic function table list.
old-location: base\rtldeletefunctiontable.htm
tech.root: Debug
ms.assetid: 42bc3d83-8053-40e9-b153-f68733d0cb2b
ms.date: 12/05/2018
ms.keywords: RtlDeleteFunctionTable, RtlDeleteFunctionTable function, base.rtldeletefunctiontable, winnt/RtlDeleteFunctionTable
f1_keywords:
- winnt/RtlDeleteFunctionTable
dev_langs:
- c++
req.header: winnt.h
req.include-header: Windows.h
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Kernel32.lib
req.dll: Kernel32.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Kernel32.dll
- API-MS-Win-Core-rtlsupport-l1-1-0.dll
- ntdll.dll
- API-MS-Win-Core-rtlsupport-l1-2-0.dll
api_name:
- RtlDeleteFunctionTable
targetos: Windows
req.typenames: 
req.redist: 
req.product: Windows XP Professional x64 Edition or 64-bit editions of     Windows Server 2003
ms.custom: 19H1
---

# RtlDeleteFunctionTable function


## -description


Removes a dynamic function table from the dynamic function table list.


## -parameters




### -param FunctionTable [in]

A pointer to an array of function entries that were previously passed to 
      <a href="https://docs.microsoft.com/windows/desktop/api/winnt/nf-winnt-rtladdfunctiontable">RtlAddFunctionTable</a> or an identifier previously 
      passed to 
      <a href="https://docs.microsoft.com/windows/desktop/api/winnt/nf-winnt-rtlinstallfunctiontablecallback">RtlInstallFunctionTableCallback</a>. For 
      a definition of the <b>PRUNTIME_FUNCTION</b> type, see WinNT.h.


## -returns



If the function succeeds, the return value is <b>TRUE</b>. Otherwise, the return value 
      is <b>FALSE</b>.




## -remarks



Function tables are used on 64-bit Windows to determine how to unwind or walk the stack. These tables are 
    usually generated by the compiler and stored as part of the image. However, applications must provide the function 
    table for dynamically generated code. For more information about function tables, see the architecture guide for 
    your system.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/winnt/nf-winnt-rtladdfunctiontable">RtlAddFunctionTable</a>



<a href="https://docs.microsoft.com/windows/desktop/api/winnt/nf-winnt-rtlinstallfunctiontablecallback">RtlInstallFunctionTableCallback</a>
 

 

