---
UID: NF:winnt.RtlInstallFunctionTableCallback
title: RtlInstallFunctionTableCallback function (winnt.h)
description: Adds a dynamic function table to the dynamic function table list.
old-location: base\rtlinstallfunctiontablecallback.htm
tech.root: Debug
ms.assetid: 63b35b17-0b0e-46ed-9dbf-98290ab08bd1
ms.date: 12/05/2018
ms.keywords: RtlInstallFunctionTableCallback, RtlInstallFunctionTableCallback function, base.rtlinstallfunctiontablecallback, winnt/RtlInstallFunctionTableCallback
f1_keywords:
- winnt/RtlInstallFunctionTableCallback
dev_langs:
- c++
req.header: winnt.h
req.include-header: Windows.h
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Kernel32.lib
req.dll: Kernel32.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Kernel32.dll
- API-MS-Win-Core-rtlsupport-l1-1-0.dll
- ntdll.dll
- API-MS-Win-Core-rtlsupport-l1-2-0.dll
api_name:
- RtlInstallFunctionTableCallback
targetos: Windows
req.typenames: 
req.redist: 
req.product: Windows XP Professional x64 Edition or 64-bit editions of     Windows Server 2003
ms.custom: 19H1
---

# RtlInstallFunctionTableCallback function


## -description


Adds a dynamic function table to the dynamic function table list.


## -parameters




### -param TableIdentifier [in]

The identifier for the dynamic function table callback. The two low-order bits must be set. For example, 
      <i>BaseAddress</i>|0x3.


### -param BaseAddress [in]

The base address of the region of memory managed by the callback function.


### -param Length [in]

The size of the region of memory managed by the callback function, in bytes.


### -param Callback [in]

A pointer to the callback function that is called to retrieve the function table entries for the functions 
      in the specified region of memory. For a definition of the 
      <b>PGET_RUNTIME_FUNCTION_CALLBACK</b> type, see WinNT.h.


### -param Context [in]

A pointer to the user-defined data to be passed to the callback function.


### -param OutOfProcessCallbackDll [in]

An optional pointer to a string that specifies the path of a DLL that provides function table entries that 
       are outside the process.

When a debugger unwinds to a function in the range of addresses managed by the callback function, it loads 
       this DLL and calls the <b>OUT_OF_PROCESS_FUNCTION_TABLE_CALLBACK_EXPORT_NAME</b> 
       function, whose type is <b>POUT_OF_PROCESS_FUNCTION_TABLE_CALLBACK</b>. For more 
       information, see the definitions of these items in WinNT.h.


## -returns



If the function succeeds, the return value is <b>TRUE</b>. If the function fails, the 
      return value is <b>FALSE</b>.




## -remarks



Function tables are used on 64-bit Windows to determine how to unwind or walk the stack. These tables are 
    usually generated by the compiler and stored as part of the image. However, applications must provide the function 
    table for dynamically generated code. For more information about function tables, see the architecture guide for 
    your system.

This function is useful for very dynamic code. The application specifies the memory range for the generated 
    code, but does not need to generate a table until it is needed by an unwind request. At that time, the system 
    calls the callback function with the <i>Context</i> and the control address. The callback 
    function must return the runtime function entry for the specified address. Be sure to avoid creating a deadlock 
    between the callback function and the code generator.

For code that is generated from a template or generated only once during the life of the process, use the 
    <a href="https://docs.microsoft.com/windows/desktop/api/winnt/nf-winnt-rtladdfunctiontable">RtlAddFunctionTable</a> function.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/winnt/nf-winnt-rtladdfunctiontable">RtlAddFunctionTable</a>



<a href="https://docs.microsoft.com/windows/desktop/api/winnt/nf-winnt-rtldeletefunctiontable">RtlDeleteFunctionTable</a>
 

 

