---
UID: NS:winnt._FILE_ID_128
title: FILE_ID_128 (winnt.h)
description: Defines a 128-bit file identifier.
old-location: fs\ext_file_id_128.htm
tech.root: FileIO
ms.assetid: 254ea6a9-e1dd-4b97-91f7-2693065c4bb8
ms.date: 12/05/2018
ms.keywords: '*PFILE_ID_128, EXT_FILE_ID_128, EXT_FILE_ID_128 structure [Files], FILE_ID_128, FILE_ID_128 structure [Files], PEXT_FILE_ID_128, PEXT_FILE_ID_128 structure pointer [Files], _FILE_ID_128, fs.ext_file_id_128, winnt/FILE_ID_128, winnt/PEXT_FILE_ID_128'
f1_keywords:
- winnt/EXT_FILE_ID_128
dev_langs:
- c++
req.header: winnt.h
req.include-header: Windows.h
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2012 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Winnt.h
api_name:
- EXT_FILE_ID_128
targetos: Windows
req.typenames: FILE_ID_128, *PFILE_ID_128
req.redist: 
ms.custom: 19H1
---

# FILE_ID_128 structure


## -description


Defines a 128-bit file identifier.


## -struct-fields




### -field Identifier

A byte array containing  the 128 bit identifier.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/winbase/ns-winbase-file_id_descriptor">FILE_ID_DESCRIPTOR</a>



<a href="https://docs.microsoft.com/windows/desktop/api/winbase/ns-winbase-file_id_extd_dir_info">FILE_ID_EXTD_DIR_INFO</a>



<a href="https://docs.microsoft.com/windows/desktop/api/winbase/ns-winbase-file_id_info">FILE_ID_INFO</a>



<a href="https://docs.microsoft.com/windows/desktop/FileIO/file-management-structures">File Management Structures</a>
 

 

