---
UID: NS:winnt._TAPE_GET_DRIVE_PARAMETERS
title: TAPE_GET_DRIVE_PARAMETERS (winnt.h)
description: Describes the tape drive. It is used by the GetTapeParameters function.
old-location: backup\tape_get_drive_parameters_str.htm
tech.root: Backup
ms.assetid: 02fc702b-3f34-47d0-b8ba-7a9f497659ad
ms.date: 12/05/2018
ms.keywords: '*PTAPE_GET_DRIVE_PARAMETERS, PTAPE_GET_DRIVE_PARAMETERS, PTAPE_GET_DRIVE_PARAMETERS structure pointer [Backup], TAPE_DRIVE_ABSOLUTE_BLK, TAPE_DRIVE_ABS_BLK_IMMED, TAPE_DRIVE_CLEAN_REQUESTS, TAPE_DRIVE_COMPRESSION, TAPE_DRIVE_ECC, TAPE_DRIVE_EJECT_MEDIA, TAPE_DRIVE_END_OF_DATA, TAPE_DRIVE_ERASE_BOP_ONLY, TAPE_DRIVE_ERASE_IMMEDIATE, TAPE_DRIVE_ERASE_LONG, TAPE_DRIVE_ERASE_SHORT, TAPE_DRIVE_FILEMARKS, TAPE_DRIVE_FIXED, TAPE_DRIVE_FIXED_BLOCK, TAPE_DRIVE_GET_ABSOLUTE_BLK, TAPE_DRIVE_GET_LOGICAL_BLK, TAPE_DRIVE_INITIATOR, TAPE_DRIVE_LOAD_UNLD_IMMED, TAPE_DRIVE_LOAD_UNLOAD, TAPE_DRIVE_LOCK_UNLK_IMMED, TAPE_DRIVE_LOCK_UNLOCK, TAPE_DRIVE_LOGICAL_BLK, TAPE_DRIVE_LOG_BLK_IMMED, TAPE_DRIVE_PADDING, TAPE_DRIVE_RELATIVE_BLKS, TAPE_DRIVE_REPORT_SMKS, TAPE_DRIVE_REVERSE_POSITION, TAPE_DRIVE_REWIND_IMMEDIATE, TAPE_DRIVE_SELECT, TAPE_DRIVE_SEQUENTIAL_FMKS, TAPE_DRIVE_SEQUENTIAL_SMKS, TAPE_DRIVE_SETMARKS, TAPE_DRIVE_SET_BLOCK_SIZE, TAPE_DRIVE_SET_CMP_BOP_ONLY, TAPE_DRIVE_SET_COMPRESSION, TAPE_DRIVE_SET_ECC, TAPE_DRIVE_SET_EOT_WZ_SIZE, TAPE_DRIVE_SET_PADDING, TAPE_DRIVE_SET_REPORT_SMKS, TAPE_DRIVE_SPACE_IMMEDIATE, TAPE_DRIVE_TAPE_CAPACITY, TAPE_DRIVE_TAPE_REMAINING, TAPE_DRIVE_TENSION, TAPE_DRIVE_TENSION_IMMED, TAPE_DRIVE_VARIABLE_BLOCK, TAPE_DRIVE_WRITE_FILEMARKS, TAPE_DRIVE_WRITE_LONG_FMKS, TAPE_DRIVE_WRITE_MARK_IMMED, TAPE_DRIVE_WRITE_PROTECT, TAPE_DRIVE_WRITE_SETMARKS, TAPE_DRIVE_WRITE_SHORT_FMKS, TAPE_GET_DRIVE_PARAMETERS, TAPE_GET_DRIVE_PARAMETERS structure [Backup], _TAPE_GET_DRIVE_PARAMETERS, _win32_tape_get_drive_parameters_str, backup.tape_get_drive_parameters_str, base.tape_get_drive_parameters_str, winnt/PTAPE_GET_DRIVE_PARAMETERS, winnt/TAPE_GET_DRIVE_PARAMETERS'
f1_keywords:
- winnt/TAPE_GET_DRIVE_PARAMETERS
dev_langs:
- c++
req.header: winnt.h
req.include-header: Windows.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Winnt.h
api_name:
- TAPE_GET_DRIVE_PARAMETERS
targetos: Windows
req.typenames: TAPE_GET_DRIVE_PARAMETERS, *PTAPE_GET_DRIVE_PARAMETERS
req.redist: 
ms.custom: 19H1
---

# TAPE_GET_DRIVE_PARAMETERS structure


## -description


The 
<b>TAPE_GET_DRIVE_PARAMETERS</b> structure describes the tape drive. It is used by the <a href="https://docs.microsoft.com/windows/desktop/api/winbase/nf-winbase-gettapeparameters">GetTapeParameters</a> function.


## -struct-fields




### -field ECC

If this member is <b>TRUE</b>, the device supports hardware error correction. Otherwise, it does not.


### -field Compression

If this member is <b>TRUE</b>, hardware data compression is enabled. Otherwise, it is disabled.


### -field DataPadding

If this member is <b>TRUE</b>, data padding is enabled. Otherwise, it is disabled. Data padding keeps the tape streaming at a constant speed.


### -field ReportSetmarks

If this member is <b>TRUE</b>, setmark reporting is enabled. Otherwise, it is disabled.


### -field DefaultBlockSize

Device's default fixed block size, in bytes.


### -field MaximumBlockSize

Device's maximum block size, in bytes.


### -field MinimumBlockSize

Device's minimum block size, in bytes.


### -field MaximumPartitionCount

Maximum number of partitions that can be created on the device.


### -field FeaturesLow

Low-order bits of the device features flag. This member can be one or more of following values. 



<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_COMPRESSION"></a><a id="tape_drive_compression"></a><dl>
<dt><b>TAPE_DRIVE_COMPRESSION</b></dt>
<dt>0x00020000</dt>
</dl>
</td>
<td width="60%">
The device supports hardware data compression.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_CLEAN_REQUESTS"></a><a id="tape_drive_clean_requests"></a><dl>
<dt><b>TAPE_DRIVE_CLEAN_REQUESTS</b></dt>
<dt>0x02000000</dt>
</dl>
</td>
<td width="60%">
The device can report if cleaning is required.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_ECC"></a><a id="tape_drive_ecc"></a><dl>
<dt><b>TAPE_DRIVE_ECC</b></dt>
<dt>0x00010000</dt>
</dl>
</td>
<td width="60%">
The device supports hardware error correction.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_EJECT_MEDIA"></a><a id="tape_drive_eject_media"></a><dl>
<dt><b>TAPE_DRIVE_EJECT_MEDIA</b></dt>
<dt>0x01000000</dt>
</dl>
</td>
<td width="60%">
The device physically ejects the tape on a software eject.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_ERASE_BOP_ONLY"></a><a id="tape_drive_erase_bop_only"></a><dl>
<dt><b>TAPE_DRIVE_ERASE_BOP_ONLY</b></dt>
<dt>0x00000040</dt>
</dl>
</td>
<td width="60%">
The device performs the erase operation from the beginning-of-partition marker only.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_ERASE_LONG"></a><a id="tape_drive_erase_long"></a><dl>
<dt><b>TAPE_DRIVE_ERASE_LONG</b></dt>
<dt>0x00000020</dt>
</dl>
</td>
<td width="60%">
The device performs a long erase operation.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_ERASE_IMMEDIATE"></a><a id="tape_drive_erase_immediate"></a><dl>
<dt><b>TAPE_DRIVE_ERASE_IMMEDIATE</b></dt>
<dt>0x00000080</dt>
</dl>
</td>
<td width="60%">
The device performs an immediate erase operation — that is, it returns when the erase operation begins.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_ERASE_SHORT"></a><a id="tape_drive_erase_short"></a><dl>
<dt><b>TAPE_DRIVE_ERASE_SHORT</b></dt>
<dt>0x00000010</dt>
</dl>
</td>
<td width="60%">
The device performs a short erase operation.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_FIXED"></a><a id="tape_drive_fixed"></a><dl>
<dt><b>TAPE_DRIVE_FIXED</b></dt>
<dt>0x00000001</dt>
</dl>
</td>
<td width="60%">
The device creates fixed data partitions.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_FIXED_BLOCK"></a><a id="tape_drive_fixed_block"></a><dl>
<dt><b>TAPE_DRIVE_FIXED_BLOCK</b></dt>
<dt>0x00000400</dt>
</dl>
</td>
<td width="60%">
The device supports fixed-length block mode.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_GET_ABSOLUTE_BLK"></a><a id="tape_drive_get_absolute_blk"></a><dl>
<dt><b>TAPE_DRIVE_GET_ABSOLUTE_BLK</b></dt>
<dt>0x00100000</dt>
</dl>
</td>
<td width="60%">
The device provides the current device-specific block address.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_GET_LOGICAL_BLK"></a><a id="tape_drive_get_logical_blk"></a><dl>
<dt><b>TAPE_DRIVE_GET_LOGICAL_BLK</b></dt>
<dt>0x00200000</dt>
</dl>
</td>
<td width="60%">
The device provides the current logical block address (and logical tape partition).

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_INITIATOR"></a><a id="tape_drive_initiator"></a><dl>
<dt><b>TAPE_DRIVE_INITIATOR</b></dt>
<dt>0x00000004</dt>
</dl>
</td>
<td width="60%">
The device creates initiator-defined partitions.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_PADDING"></a><a id="tape_drive_padding"></a><dl>
<dt><b>TAPE_DRIVE_PADDING</b></dt>
<dt>0x00040000</dt>
</dl>
</td>
<td width="60%">
The device supports data padding.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_REPORT_SMKS"></a><a id="tape_drive_report_smks"></a><dl>
<dt><b>TAPE_DRIVE_REPORT_SMKS</b></dt>
<dt>0x00080000</dt>
</dl>
</td>
<td width="60%">
The device supports setmark reporting.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_SELECT"></a><a id="tape_drive_select"></a><dl>
<dt><b>TAPE_DRIVE_SELECT</b></dt>
<dt>0x00000002</dt>
</dl>
</td>
<td width="60%">
The device creates select data partitions.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_SET_CMP_BOP_ONLY"></a><a id="tape_drive_set_cmp_bop_only"></a><dl>
<dt><b>TAPE_DRIVE_SET_CMP_BOP_ONLY</b></dt>
<dt>0x04000000</dt>
</dl>
</td>
<td width="60%">
The device must be at the beginning of a partition before it can set compression on.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_SET_EOT_WZ_SIZE"></a><a id="tape_drive_set_eot_wz_size"></a><dl>
<dt><b>TAPE_DRIVE_SET_EOT_WZ_SIZE</b></dt>
<dt>0x00400000</dt>
</dl>
</td>
<td width="60%">
The device supports setting the end-of-medium warning size.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_TAPE_CAPACITY"></a><a id="tape_drive_tape_capacity"></a><dl>
<dt><b>TAPE_DRIVE_TAPE_CAPACITY</b></dt>
<dt>0x00000100</dt>
</dl>
</td>
<td width="60%">
The device returns the maximum capacity of the tape.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_TAPE_REMAINING"></a><a id="tape_drive_tape_remaining"></a><dl>
<dt><b>TAPE_DRIVE_TAPE_REMAINING</b></dt>
<dt>0x00000200</dt>
</dl>
</td>
<td width="60%">
The device returns the remaining capacity of the tape.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_VARIABLE_BLOCK"></a><a id="tape_drive_variable_block"></a><dl>
<dt><b>TAPE_DRIVE_VARIABLE_BLOCK</b></dt>
<dt>0x00000800</dt>
</dl>
</td>
<td width="60%">
The device supports variable-length block mode.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_WRITE_PROTECT"></a><a id="tape_drive_write_protect"></a><dl>
<dt><b>TAPE_DRIVE_WRITE_PROTECT</b></dt>
<dt>0x00001000</dt>
</dl>
</td>
<td width="60%">
The device returns an error if the tape is write-enabled or write-protected.

</td>
</tr>
</table>
 


### -field FeaturesHigh

High-order bits of the device features flag. This member can be one or more of the following values. 



<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_ABS_BLK_IMMED"></a><a id="tape_drive_abs_blk_immed"></a><dl>
<dt><b>TAPE_DRIVE_ABS_BLK_IMMED</b></dt>
<dt>0x80002000</dt>
</dl>
</td>
<td width="60%">
The device moves the tape to a device-specific block address and returns as soon as the move begins.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_ABSOLUTE_BLK"></a><a id="tape_drive_absolute_blk"></a><dl>
<dt><b>TAPE_DRIVE_ABSOLUTE_BLK</b></dt>
<dt>0x80001000</dt>
</dl>
</td>
<td width="60%">
The device moves the tape to a device specific block address.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_END_OF_DATA"></a><a id="tape_drive_end_of_data"></a><dl>
<dt><b>TAPE_DRIVE_END_OF_DATA</b></dt>
<dt>0x80010000</dt>
</dl>
</td>
<td width="60%">
The device moves the tape to the end-of-data marker in a partition.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_FILEMARKS"></a><a id="tape_drive_filemarks"></a><dl>
<dt><b>TAPE_DRIVE_FILEMARKS</b></dt>
<dt>0x80040000</dt>
</dl>
</td>
<td width="60%">
The device moves the tape forward (or backward) a specified number of filemarks.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_LOAD_UNLOAD"></a><a id="tape_drive_load_unload"></a><dl>
<dt><b>TAPE_DRIVE_LOAD_UNLOAD</b></dt>
<dt>0x80000001</dt>
</dl>
</td>
<td width="60%">
The device enables and disables the device for further operations.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_LOAD_UNLD_IMMED"></a><a id="tape_drive_load_unld_immed"></a><dl>
<dt><b>TAPE_DRIVE_LOAD_UNLD_IMMED</b></dt>
<dt>0x80000020</dt>
</dl>
</td>
<td width="60%">
The device supports immediate load and unload operations.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_LOCK_UNLOCK"></a><a id="tape_drive_lock_unlock"></a><dl>
<dt><b>TAPE_DRIVE_LOCK_UNLOCK</b></dt>
<dt>0x80000004</dt>
</dl>
</td>
<td width="60%">
The device enables and disables the tape ejection mechanism.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_LOCK_UNLK_IMMED"></a><a id="tape_drive_lock_unlk_immed"></a><dl>
<dt><b>TAPE_DRIVE_LOCK_UNLK_IMMED</b></dt>
<dt>0x80000080</dt>
</dl>
</td>
<td width="60%">
The device supports immediate lock and unlock operations.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_LOG_BLK_IMMED"></a><a id="tape_drive_log_blk_immed"></a><dl>
<dt><b>TAPE_DRIVE_LOG_BLK_IMMED</b></dt>
<dt>0x80008000</dt>
</dl>
</td>
<td width="60%">
The device moves the tape to a logical block address in a partition and returns as soon as the move begins.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_LOGICAL_BLK"></a><a id="tape_drive_logical_blk"></a><dl>
<dt><b>TAPE_DRIVE_LOGICAL_BLK</b></dt>
<dt>0x80004000</dt>
</dl>
</td>
<td width="60%">
The device moves the tape to a logical block address in a partition.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_RELATIVE_BLKS"></a><a id="tape_drive_relative_blks"></a><dl>
<dt><b>TAPE_DRIVE_RELATIVE_BLKS</b></dt>
<dt>0x80020000</dt>
</dl>
</td>
<td width="60%">
The device moves the tape forward (or backward) a specified number of blocks.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_REVERSE_POSITION"></a><a id="tape_drive_reverse_position"></a><dl>
<dt><b>TAPE_DRIVE_REVERSE_POSITION</b></dt>
<dt>0x80400000</dt>
</dl>
</td>
<td width="60%">
The device moves the tape backward over blocks, filemarks, or setmarks.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_REWIND_IMMEDIATE"></a><a id="tape_drive_rewind_immediate"></a><dl>
<dt><b>TAPE_DRIVE_REWIND_IMMEDIATE</b></dt>
<dt>0x80000008</dt>
</dl>
</td>
<td width="60%">
The device supports immediate rewind operation.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_SEQUENTIAL_FMKS"></a><a id="tape_drive_sequential_fmks"></a><dl>
<dt><b>TAPE_DRIVE_SEQUENTIAL_FMKS</b></dt>
<dt>0x80080000</dt>
</dl>
</td>
<td width="60%">
The device moves the tape forward (or backward) to the first occurrence of a specified number of consecutive filemarks.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_SEQUENTIAL_SMKS"></a><a id="tape_drive_sequential_smks"></a><dl>
<dt><b>TAPE_DRIVE_SEQUENTIAL_SMKS</b></dt>
<dt>0x80200000</dt>
</dl>
</td>
<td width="60%">
The device moves the tape forward (or backward) to the first occurrence of a specified number of consecutive setmarks.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_SET_BLOCK_SIZE"></a><a id="tape_drive_set_block_size"></a><dl>
<dt><b>TAPE_DRIVE_SET_BLOCK_SIZE</b></dt>
<dt>0x80000010</dt>
</dl>
</td>
<td width="60%">
The device supports setting the size of a fixed-length logical block or setting the variable-length block mode.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_SET_COMPRESSION"></a><a id="tape_drive_set_compression"></a><dl>
<dt><b>TAPE_DRIVE_SET_COMPRESSION</b></dt>
<dt>0x80000200</dt>
</dl>
</td>
<td width="60%">
The device enables and disables hardware data compression.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_SET_ECC"></a><a id="tape_drive_set_ecc"></a><dl>
<dt><b>TAPE_DRIVE_SET_ECC</b></dt>
<dt>0x80000100</dt>
</dl>
</td>
<td width="60%">
The device enables and disables hardware error correction.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_SET_PADDING"></a><a id="tape_drive_set_padding"></a><dl>
<dt><b>TAPE_DRIVE_SET_PADDING</b></dt>
<dt>0x80000400</dt>
</dl>
</td>
<td width="60%">
The device enables and disables data padding.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_SET_REPORT_SMKS"></a><a id="tape_drive_set_report_smks"></a><dl>
<dt><b>TAPE_DRIVE_SET_REPORT_SMKS</b></dt>
<dt>0x80000800</dt>
</dl>
</td>
<td width="60%">
The device enables and disables the reporting of setmarks.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_SETMARKS"></a><a id="tape_drive_setmarks"></a><dl>
<dt><b>TAPE_DRIVE_SETMARKS</b></dt>
<dt>0x80100000</dt>
</dl>
</td>
<td width="60%">
The device moves the tape forward (or reverse) a specified number of setmarks.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_SPACE_IMMEDIATE"></a><a id="tape_drive_space_immediate"></a><dl>
<dt><b>TAPE_DRIVE_SPACE_IMMEDIATE</b></dt>
<dt>0x80800000</dt>
</dl>
</td>
<td width="60%">
The device supports immediate spacing.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_TENSION"></a><a id="tape_drive_tension"></a><dl>
<dt><b>TAPE_DRIVE_TENSION</b></dt>
<dt>0x80000002</dt>
</dl>
</td>
<td width="60%">
The device supports tape tensioning.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_TENSION_IMMED"></a><a id="tape_drive_tension_immed"></a><dl>
<dt><b>TAPE_DRIVE_TENSION_IMMED</b></dt>
<dt>0x80000040</dt>
</dl>
</td>
<td width="60%">
The device supports immediate tape tensioning.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_WRITE_FILEMARKS"></a><a id="tape_drive_write_filemarks"></a><dl>
<dt><b>TAPE_DRIVE_WRITE_FILEMARKS</b></dt>
<dt>0x82000000</dt>
</dl>
</td>
<td width="60%">
The device writes filemarks.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_WRITE_LONG_FMKS"></a><a id="tape_drive_write_long_fmks"></a><dl>
<dt><b>TAPE_DRIVE_WRITE_LONG_FMKS</b></dt>
<dt>0x88000000</dt>
</dl>
</td>
<td width="60%">
The device writes long filemarks.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_WRITE_MARK_IMMED"></a><a id="tape_drive_write_mark_immed"></a><dl>
<dt><b>TAPE_DRIVE_WRITE_MARK_IMMED</b></dt>
<dt>0x90000000</dt>
</dl>
</td>
<td width="60%">
The device supports immediate writing of short and long filemarks.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_WRITE_SETMARKS"></a><a id="tape_drive_write_setmarks"></a><dl>
<dt><b>TAPE_DRIVE_WRITE_SETMARKS</b></dt>
<dt>0x81000000</dt>
</dl>
</td>
<td width="60%">
The device writes setmarks.

</td>
</tr>
<tr>
<td width="40%"><a id="TAPE_DRIVE_WRITE_SHORT_FMKS"></a><a id="tape_drive_write_short_fmks"></a><dl>
<dt><b>TAPE_DRIVE_WRITE_SHORT_FMKS</b></dt>
<dt>0x84000000</dt>
</dl>
</td>
<td width="60%">
The device writes short filemarks.

</td>
</tr>
</table>
 


### -field EOTWarningZoneSize

Indicates the number of bytes between the end-of-tape warning and the physical end of the tape.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/winbase/nf-winbase-gettapeparameters">GetTapeParameters</a>
 

 

