---
UID: NS:winnt._TOKEN_AUDIT_POLICY
title: TOKEN_AUDIT_POLICY (winnt.h)
description: Specifies the per user audit policy for a token.
old-location: security\token_audit_policy.htm
tech.root: SecAuthZ
ms.assetid: 02c03560-4886-4a63-ba0d-c77494d6595e
ms.date: 12/05/2018
ms.keywords: '*PTOKEN_AUDIT_POLICY, PTOKEN_AUDIT_POLICY, PTOKEN_AUDIT_POLICY structure pointer [Security], TOKEN_AUDIT_POLICY, TOKEN_AUDIT_POLICY structure [Security], _TOKEN_AUDIT_POLICY, security.token_audit_policy, winnt/PTOKEN_AUDIT_POLICY, winnt/TOKEN_AUDIT_POLICY'
f1_keywords:
- winnt/TOKEN_AUDIT_POLICY
dev_langs:
- c++
req.header: winnt.h
req.include-header: Windows.h
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Winnt.h
api_name:
- TOKEN_AUDIT_POLICY
targetos: Windows
req.typenames: TOKEN_AUDIT_POLICY, *PTOKEN_AUDIT_POLICY
req.redist: 
ms.custom: 19H1
---

# TOKEN_AUDIT_POLICY structure


## -description


The <b>TOKEN_AUDIT_POLICY</b> structure specifies the per user audit policy for a token.


## -struct-fields




### -field PerUserPolicy

Specifies the per user audit policy for the token.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/winnt/ne-winnt-token_information_class">TOKEN_INFORMATION_CLASS</a>
 

 

