---
UID: NF:winscard.GetOpenCardNameW
title: GetOpenCardNameW function (winscard.h)
description: The GetOpenCardName function displays the smart card &#0034;select card&#0034; dialog box.
old-location: security\getopencardname.htm
tech.root: SecAuthN
ms.assetid: b103cec0-dd28-4f90-864b-5f66d044ec55
ms.date: 12/05/2018
ms.keywords: GetOpenCardName, GetOpenCardName function [Security], GetOpenCardNameA, GetOpenCardNameW, _smart_getopencardname, security.getopencardname, winscard/GetOpenCardName, winscard/GetOpenCardNameA, winscard/GetOpenCardNameW
f1_keywords:
- winscard/GetOpenCardName
dev_langs:
- c++
req.header: winscard.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: GetOpenCardNameW (Unicode) and GetOpenCardNameA (ANSI)
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Scarddlg.lib
req.dll: Scarddlg.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Scarddlg.dll
api_name:
- GetOpenCardName
- GetOpenCardNameA
- GetOpenCardNameW
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# GetOpenCardNameW function


## -description


The <b>GetOpenCardName</b> function displays the <a href="https://docs.microsoft.com/windows/desktop/SecGloss/s-gly">smart card</a> "select card" dialog box. Call the function 
<a href="https://docs.microsoft.com/windows/desktop/api/winscard/nf-winscard-scarduidlgselectcarda">SCardUIDlgSelectCard</a> instead of <b>GetOpenCardName</b>. The <b>GetOpenCardName</b> function is maintained for backward compatibility with version 1.0 of the Microsoft Smart Card Base Components, but calls to <b>GetOpenCardName</b> are mapped to <b>SCardUIDlgSelectCard</b>.
		


## -parameters




### -param Arg1 [in]

A pointer to the 
<a href="https://docs.microsoft.com/windows/desktop/api/winscard/ns-winscard-opencardnamea">OPENCARDNAME</a> structure for the "select card" dialog box.


## -returns



The function returns different values depending on whether it succeeds or fails.
						
						
					

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>Success</b></dt>
</dl>
</td>
<td width="60%">
SCARD_S_SUCCESS.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>Failure</b></dt>
</dl>
</td>
<td width="60%">
An error code. For more information, see 
<a href="https://docs.microsoft.com/windows/desktop/SecAuthN/authentication-return-values">Smart Card Return Values</a>.

</td>
</tr>
</table>
 




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/winscard/ns-winscard-opencardnamea">OPENCARDNAME</a>
 

 

