---
UID: NC:winuser.WINEVENTPROC
title: WINEVENTPROC (winuser.h)
description: An application-defined callback (or hook) function that the system calls in response to events generated by an accessible object.
old-location: winauto\wineventproc_callback_function.htm
tech.root: WinAuto
ms.assetid: 5fe3cacc-4563-43da-960d-729d3fe4ff70
ms.date: 12/05/2018
ms.keywords: WinEventProc, WinEventProc callback, WinEventProc callback function [Windows Accessibility], msaa.wineventproc_callback_function, winauto.wineventproc_callback_function, winuser/WinEventProc
f1_keywords:
- winuser/WinEventProc
dev_langs:
- c++
req.header: winuser.h
req.include-header: Windows.h
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- UserDefined
api_location:
- Winuser.h
api_name:
- WinEventProc
targetos: Windows
req.typenames: 
req.redist: Active Accessibility 1.3 RDK on Windows NT 4.0 with SP6 and later and Windows 95
ms.custom: 19H1
---

# WINEVENTPROC callback function


## -description


An application-defined callback (or hook) function that the system calls in response to events generated by an accessible object. The hook function processes the event notifications as required. Clients install the hook function and request specific types of event notifications by calling <a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-setwineventhook">SetWinEventHook</a>.

The <a href="https://docs.microsoft.com/previous-versions/windows/desktop/legacy/dd373882(v=vs.85)">WINEVENTPROC</a> type defines a pointer to this callback function. <i>WinEventProc</i> is a placeholder for the application-defined function name.


## -parameters




### -param hWinEventHook

Type: <b>HWINEVENTHOOK</b>

Handle to an event hook function. This value is returned by <a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-setwineventhook">SetWinEventHook</a> when the hook function is installed and is specific to each instance of the hook function.


### -param event

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">DWORD</a></b>

Specifies the event that occurred. This value is one of the <a href="https://docs.microsoft.com/windows/desktop/WinAuto/event-constants">event constants</a>.


### -param hwnd

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">HWND</a></b>

Handle to the window that generates the event, or <b>NULL</b> if no window is associated with the event. For example, the mouse pointer is not associated with a window.


### -param idObject

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">LONG</a></b>

Identifies the object associated with the event. This is one of the <a href="https://docs.microsoft.com/windows/desktop/WinAuto/object-identifiers">object identifiers</a> or a custom object ID.


### -param idChild

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">LONG</a></b>

Identifies whether the event was triggered by an object or a child element of the object. If this value is CHILDID_SELF, the event was triggered by the object; otherwise, this value is the child ID of the element that triggered the event.


### -param idEventThread


### -param dwmsEventTime

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">DWORD</a></b>

Specifies the time, in milliseconds, that the event was generated.


#### - dwEventThread

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">DWORD</a></b>

Identifies the thread that generated the event, or the thread that owns the current window.


## -returns



This callback function does not return a value.




## -remarks



Within the hook function, the parameters <i>hwnd</i>, <i>idObject</i>, and <i>idChild</i> are used when calling <a href="https://docs.microsoft.com/windows/desktop/api/oleacc/nf-oleacc-accessibleobjectfromevent">AccessibleObjectFromEvent</a>.

Servers generate events by calling <a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-notifywinevent">NotifyWinEvent</a>.

Create multiple callback functions to handle different events. For more information, see <a href="https://docs.microsoft.com/windows/desktop/WinAuto/registering-a-hook-function">Registering a Hook Function</a>.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-setwineventhook">SetWinEventHook</a>
 

 

