---
UID: NE:winuser.tagFEEDBACK_TYPE
title: FEEDBACK_TYPE (winuser.h)
description: Specifies the visual feedback associated with an event.
old-location: input_feedback\feedback_type.htm
tech.root: Input_Feedback
ms.assetid: EEA3024E-D38C-4F4D-A63C-58ECB2B87F20
ms.date: 12/05/2018
ms.keywords: FEEDBACK_GESTURE_PRESSANDTAP, FEEDBACK_MAX, FEEDBACK_PEN_BARRELVISUALIZATION, FEEDBACK_PEN_DOUBLETAP, FEEDBACK_PEN_PRESSANDHOLD, FEEDBACK_PEN_RIGHTTAP, FEEDBACK_PEN_TAP, FEEDBACK_TOUCH_CONTACTVISUALIZATION, FEEDBACK_TOUCH_DOUBLETAP, FEEDBACK_TOUCH_PRESSANDHOLD, FEEDBACK_TOUCH_RIGHTTAP, FEEDBACK_TOUCH_TAP, FEEDBACK_TYPE, FEEDBACK_TYPE enumeration, input_feedback.feedback_type, inputfeedbackui.feedback_type_, winuser/FEEDBACK_GESTURE_PRESSANDTAP, winuser/FEEDBACK_MAX, winuser/FEEDBACK_PEN_BARRELVISUALIZATION, winuser/FEEDBACK_PEN_DOUBLETAP, winuser/FEEDBACK_PEN_PRESSANDHOLD, winuser/FEEDBACK_PEN_RIGHTTAP, winuser/FEEDBACK_PEN_TAP, winuser/FEEDBACK_TOUCH_CONTACTVISUALIZATION, winuser/FEEDBACK_TOUCH_DOUBLETAP, winuser/FEEDBACK_TOUCH_PRESSANDHOLD, winuser/FEEDBACK_TOUCH_RIGHTTAP, winuser/FEEDBACK_TOUCH_TAP, winuser/FEEDBACK_TYPE
f1_keywords:
- winuser/FEEDBACK_TYPE
dev_langs:
- c++
req.header: winuser.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 [desktop apps only]
req.target-min-winversvr: Windows Server 2012 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- winuser.h
api_name:
- FEEDBACK_TYPE
targetos: Windows
req.typenames: FEEDBACK_TYPE
req.redist: 
ms.custom: 19H1
---

# FEEDBACK_TYPE enumeration


## -description


Specifies  the visual feedback associated with an event.


## -enum-fields




### -field FEEDBACK_TOUCH_CONTACTVISUALIZATION

Feedback for a touch contact event.


### -field FEEDBACK_PEN_BARRELVISUALIZATION

Feedback for a pen barrel-button event.


### -field FEEDBACK_PEN_TAP

Feedback for a pen tap event.


### -field FEEDBACK_PEN_DOUBLETAP

Feedback for a pen double-tap event.


### -field FEEDBACK_PEN_PRESSANDHOLD

Feedback for a pen press-and-hold event.


### -field FEEDBACK_PEN_RIGHTTAP

Feedback for a pen right-tap event.


### -field FEEDBACK_TOUCH_TAP

Feedback for a touch tap event.


### -field FEEDBACK_TOUCH_DOUBLETAP

Feedback for a touch double-tap event.


### -field FEEDBACK_TOUCH_PRESSANDHOLD

Feedback for a touch press-and-hold event.


### -field FEEDBACK_TOUCH_RIGHTTAP

Feedback for a touch right-tap event.


### -field FEEDBACK_GESTURE_PRESSANDTAP

Feedback for a press-and-tap gesture.


### -field FEEDBACK_MAX

Do not use.


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/input_feedback/enumerations">Enumerations</a>
 

 

