---
UID: NF:winuser.GET_FLAGS_LPARAM
title: GET_FLAGS_LPARAM macro (winuser.h)
description: Retrieves the state of certain virtual keys from the specified LPARAM value.
old-location: inputdev\get_flags_lparam.htm
tech.root: inputdev
ms.assetid: VS|winui|~\winui\windowsuserinterface\userinput\mouseinput\mouseinputreference\mouseinputmacros\get_flags_lparam.htm
ms.date: 12/05/2018
ms.keywords: GET_FLAGS_LPARAM, GET_FLAGS_LPARAM macro [Keyboard and Mouse Input], _win32_GET_FLAGS_LPARAM, _win32_get_flags_lparam_cpp, inputdev.get_flags_lparam, winui._win32_get_flags_lparam, winuser/GET_FLAGS_LPARAM
f1_keywords:
- winuser/GET_FLAGS_LPARAM
dev_langs:
- c++
req.header: winuser.h
req.include-header: Windows.h
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Winuser.h
api_name:
- GET_FLAGS_LPARAM
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# GET_FLAGS_LPARAM macro


## -description


Retrieves the state of certain virtual keys from the specified 
			<b>LPARAM</b> value.


## -parameters




### -param lParam

The value to be converted. 


## -remarks



This macro is identical to the <a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-get_keystate_lparam">GET_KEYSTATE_LPARAM</a> macro.




## -see-also




<b>Conceptual</b>



<a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-get_keystate_lparam">GET_KEYSTATE_LPARAM</a>



<a href="https://docs.microsoft.com/windows/desktop/inputdev/mouse-input">Mouse Input</a>



<b>Reference</b>
 

 

