---
UID: NF:winuser.GetSystemMetrics
title: GetSystemMetrics function (winuser.h)
description: Retrieves the specified system metric or system configuration setting.
old-location: winmsg\getsystemmetrics.htm
tech.root: winmsg
ms.assetid: d063857b-6036-4e68-80af-9c70d12ae29e
ms.date: 12/05/2018
ms.keywords: GetSystemMetrics, GetSystemMetrics function [Windows and Messages], SM_ARRANGE, SM_CLEANBOOT, SM_CMONITORS, SM_CMOUSEBUTTONS, SM_CONVERTIBLESLATEMODE, SM_CXBORDER, SM_CXCURSOR, SM_CXDLGFRAME, SM_CXDOUBLECLK, SM_CXDRAG, SM_CXEDGE, SM_CXFIXEDFRAME, SM_CXFOCUSBORDER, SM_CXFRAME, SM_CXFULLSCREEN, SM_CXHSCROLL, SM_CXHTHUMB, SM_CXICON, SM_CXICONSPACING, SM_CXMAXIMIZED, SM_CXMAXTRACK, SM_CXMENUCHECK, SM_CXMENUSIZE, SM_CXMIN, SM_CXMINIMIZED, SM_CXMINSPACING, SM_CXMINTRACK, SM_CXPADDEDBORDER, SM_CXSCREEN, SM_CXSIZE, SM_CXSIZEFRAME, SM_CXSMICON, SM_CXSMSIZE, SM_CXVIRTUALSCREEN, SM_CXVSCROLL, SM_CYBORDER, SM_CYCAPTION, SM_CYCURSOR, SM_CYDLGFRAME, SM_CYDOUBLECLK, SM_CYDRAG, SM_CYEDGE, SM_CYFIXEDFRAME, SM_CYFOCUSBORDER, SM_CYFRAME, SM_CYFULLSCREEN, SM_CYHSCROLL, SM_CYICON, SM_CYICONSPACING, SM_CYKANJIWINDOW, SM_CYMAXIMIZED, SM_CYMAXTRACK, SM_CYMENU, SM_CYMENUCHECK, SM_CYMENUSIZE, SM_CYMIN, SM_CYMINIMIZED, SM_CYMINSPACING, SM_CYMINTRACK, SM_CYSCREEN, SM_CYSIZE, SM_CYSIZEFRAME, SM_CYSMCAPTION, SM_CYSMICON, SM_CYSMSIZE, SM_CYVIRTUALSCREEN, SM_CYVSCROLL, SM_CYVTHUMB, SM_DBCSENABLED, SM_DEBUG, SM_DIGITIZER, SM_IMMENABLED, SM_MAXIMUMTOUCHES, SM_MEDIACENTER, SM_MENUDROPALIGNMENT, SM_MIDEASTENABLED, SM_MOUSEHORIZONTALWHEELPRESENT, SM_MOUSEPRESENT, SM_MOUSEWHEELPRESENT, SM_NETWORK, SM_PENWINDOWS, SM_REMOTECONTROL, SM_REMOTESESSION, SM_SAMEDISPLAYFORMAT, SM_SECURE, SM_SERVERR2, SM_SHOWSOUNDS, SM_SHUTTINGDOWN, SM_SLOWMACHINE, SM_STARTER, SM_SWAPBUTTON, SM_SYSTEMDOCKED, SM_TABLETPC, SM_XVIRTUALSCREEN, SM_YVIRTUALSCREEN, _win32_getsystemmetrics, base.getsystemmetrics, getsystemmetrics_cpp, winmsg.getsystemmetrics, winui.getsystemmetrics, winuser/GetSystemMetrics
f1_keywords:
- winuser/GetSystemMetrics
dev_langs:
- c++
req.header: winuser.h
req.include-header: Windows.h
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: User32.lib
req.dll: User32.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- User32.dll
- Ext-MS-Win-NTUser-sysparams-Ext-l1-1-0.dll
- Ext-MS-Win-RTCore-NTUser-sysparams-l1-1-0.dll
- minuser.dll
- api-ms-win-ntuser-sysparams-l1-1-0.dll
api_name:
- GetSystemMetrics
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# GetSystemMetrics function


## -description


Retrieves the specified 
    system metric or system configuration setting.

Note that all dimensions 
    retrieved by <b>GetSystemMetrics</b> are in pixels.


## -parameters




### -param nIndex [in]

Type: <b>int</b>

The system metric or configuration setting to be retrieved. This parameter can be one of the following values. 
      Note that all SM_CX* values are widths and all SM_CY* values are heights. Also note that all settings 
      designed to return Boolean data represent <b>TRUE</b> as any nonzero value, and <b>FALSE</b> as a zero value.

<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="SM_ARRANGE"></a><a id="sm_arrange"></a><dl>
<dt><b>SM_ARRANGE</b></dt>
<dt>56</dt>
</dl>
</td>
<td width="60%">
The flags that specify how the system arranged minimized windows. For more information, see the Remarks section in this topic.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CLEANBOOT"></a><a id="sm_cleanboot"></a><dl>
<dt><b>SM_CLEANBOOT</b></dt>
<dt>67</dt>
</dl>
</td>
<td width="60%">
The value that specifies how the system is started: 
        

<ul>
<li>0 Normal boot</li>
<li>1 Fail-safe boot</li>
<li>2 Fail-safe with network boot</li>
</ul>
A fail-safe boot (also called SafeBoot, Safe Mode, or Clean Boot) bypasses the user startup files.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CMONITORS"></a><a id="sm_cmonitors"></a><dl>
<dt><b>SM_CMONITORS</b></dt>
<dt>80</dt>
</dl>
</td>
<td width="60%">
The number of display monitors on a desktop. For more information, see the Remarks section in this topic.
        

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CMOUSEBUTTONS"></a><a id="sm_cmousebuttons"></a><dl>
<dt><b>SM_CMOUSEBUTTONS</b></dt>
<dt>43</dt>
</dl>
</td>
<td width="60%">
The number of buttons on a mouse, or zero if no mouse is installed.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CONVERTIBLESLATEMODE"></a><a id="sm_convertibleslatemode"></a><dl>
<dt><b>SM_CONVERTIBLESLATEMODE</b></dt>
<dt>0x2003</dt>
</dl>
</td>
<td width="60%">
Reflects the state of the laptop or slate mode, 0 for Slate Mode and non-zero otherwise. When this system metric changes, the system sends a broadcast message via <a href="https://docs.microsoft.com/windows/desktop/winmsg/wm-settingchange">WM_SETTINGCHANGE</a> with "ConvertibleSlateMode" in the LPARAM. Note that this system metric doesn't apply to desktop PCs. In that case, use <a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-getautorotationstate">GetAutoRotationState</a>.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXBORDER"></a><a id="sm_cxborder"></a><dl>
<dt><b>SM_CXBORDER</b></dt>
<dt>5</dt>
</dl>
</td>
<td width="60%">
The width of a window border, in pixels. This is equivalent to the SM_CXEDGE value for 
        windows with the 3-D look.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXCURSOR"></a><a id="sm_cxcursor"></a><dl>
<dt><b>SM_CXCURSOR</b></dt>
<dt>13</dt>
</dl>
</td>
<td width="60%">
The width of a cursor, in pixels. The system cannot create cursors of other sizes.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXDLGFRAME"></a><a id="sm_cxdlgframe"></a><dl>
<dt><b>SM_CXDLGFRAME</b></dt>
<dt>7</dt>
</dl>
</td>
<td width="60%">
This value is the same as SM_CXFIXEDFRAME.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXDOUBLECLK"></a><a id="sm_cxdoubleclk"></a><dl>
<dt><b>SM_CXDOUBLECLK</b></dt>
<dt>36</dt>
</dl>
</td>
<td width="60%">
The width of the rectangle around the location of a first click in a double-click sequence, 
        in pixels. The second click must occur within the rectangle that is defined by SM_CXDOUBLECLK and SM_CYDOUBLECLK for the system to consider the two 
        clicks a double-click. The two clicks must also occur within a specified time. 
        

To set the width of the double-click rectangle, call 
         <a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-systemparametersinfoa">SystemParametersInfo</a> with SPI_SETDOUBLECLKWIDTH.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXDRAG"></a><a id="sm_cxdrag"></a><dl>
<dt><b>SM_CXDRAG</b></dt>
<dt>68</dt>
</dl>
</td>
<td width="60%">
The number of pixels on either side of a mouse-down point that  the mouse
       pointer can move before a drag operation begins. This allows the user to click and release the
       mouse button easily without unintentionally starting a drag operation. If this value is negative, it is subtracted from the left of the mouse-down point and added to the right of it.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXEDGE"></a><a id="sm_cxedge"></a><dl>
<dt><b>SM_CXEDGE</b></dt>
<dt>45</dt>
</dl>
</td>
<td width="60%">
The width of a 3-D border, in pixels. This metric is the 3-D counterpart of SM_CXBORDER.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXFIXEDFRAME"></a><a id="sm_cxfixedframe"></a><dl>
<dt><b>SM_CXFIXEDFRAME</b></dt>
<dt>7</dt>
</dl>
</td>
<td width="60%">
The thickness of the frame around the perimeter of a window that has a caption but is not sizable, in pixels.
       SM_CXFIXEDFRAME is the height of the horizontal border, and SM_CYFIXEDFRAME is the width of the vertical border. 
       

This value is the same as SM_CXDLGFRAME.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXFOCUSBORDER"></a><a id="sm_cxfocusborder"></a><dl>
<dt><b>SM_CXFOCUSBORDER</b></dt>
<dt>83</dt>
</dl>
</td>
<td width="60%">
The width of the left and right edges of the focus rectangle that the <a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-drawfocusrect">DrawFocusRect</a> draws. This value is in pixels.
       

<b>Windows 2000:  </b>This value is not supported.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXFRAME"></a><a id="sm_cxframe"></a><dl>
<dt><b>SM_CXFRAME</b></dt>
<dt>32</dt>
</dl>
</td>
<td width="60%">
This value is the same as SM_CXSIZEFRAME.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXFULLSCREEN"></a><a id="sm_cxfullscreen"></a><dl>
<dt><b>SM_CXFULLSCREEN</b></dt>
<dt>16</dt>
</dl>
</td>
<td width="60%">
The width of the client area for a full-screen window on the primary display monitor, in pixels. To
       get the coordinates of the portion of the screen that is not obscured by the system taskbar or by application desktop
       toolbars, call the 
       <a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-systemparametersinfoa">SystemParametersInfo</a> function with
       the SPI_GETWORKAREA value.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXHSCROLL"></a><a id="sm_cxhscroll"></a><dl>
<dt><b>SM_CXHSCROLL</b></dt>
<dt>21</dt>
</dl>
</td>
<td width="60%">
The width of the arrow bitmap on a horizontal scroll bar, in pixels.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXHTHUMB"></a><a id="sm_cxhthumb"></a><dl>
<dt><b>SM_CXHTHUMB</b></dt>
<dt>10</dt>
</dl>
</td>
<td width="60%">
The width of the thumb box in a horizontal scroll bar, in pixels.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXICON"></a><a id="sm_cxicon"></a><dl>
<dt><b>SM_CXICON</b></dt>
<dt>11</dt>
</dl>
</td>
<td width="60%">
The default width of an icon, in pixels. The 
       <a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-loadicona">LoadIcon</a> function can load only icons with the  dimensions that SM_CXICON and SM_CYICON specifies.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXICONSPACING"></a><a id="sm_cxiconspacing"></a><dl>
<dt><b>SM_CXICONSPACING</b></dt>
<dt>38</dt>
</dl>
</td>
<td width="60%">
The width of a grid cell for items in large icon view, in pixels. Each item fits into a rectangle of size SM_CXICONSPACING by SM_CYICONSPACING when arranged. This value is always greater than or equal to SM_CXICON.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXMAXIMIZED"></a><a id="sm_cxmaximized"></a><dl>
<dt><b>SM_CXMAXIMIZED</b></dt>
<dt>61</dt>
</dl>
</td>
<td width="60%">
The default width, in pixels, of a maximized top-level window on the primary display monitor.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXMAXTRACK"></a><a id="sm_cxmaxtrack"></a><dl>
<dt><b>SM_CXMAXTRACK</b></dt>
<dt>59</dt>
</dl>
</td>
<td width="60%">
The default maximum width of a window that has a caption and sizing borders, in pixels. This metric
       refers to the entire desktop. The user cannot drag the window frame to a size larger than these dimensions. A
       window can override this value by processing the 
       <a href="https://docs.microsoft.com/windows/desktop/winmsg/wm-getminmaxinfo">WM_GETMINMAXINFO</a> message.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXMENUCHECK"></a><a id="sm_cxmenucheck"></a><dl>
<dt><b>SM_CXMENUCHECK</b></dt>
<dt>71</dt>
</dl>
</td>
<td width="60%">
The width of the default menu check-mark bitmap, in pixels.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXMENUSIZE"></a><a id="sm_cxmenusize"></a><dl>
<dt><b>SM_CXMENUSIZE</b></dt>
<dt>54</dt>
</dl>
</td>
<td width="60%">
The width of menu bar buttons, such as the child window close button that is used in the multiple document
       interface, in pixels.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXMIN"></a><a id="sm_cxmin"></a><dl>
<dt><b>SM_CXMIN</b></dt>
<dt>28</dt>
</dl>
</td>
<td width="60%">
The minimum width of a window, in pixels.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXMINIMIZED"></a><a id="sm_cxminimized"></a><dl>
<dt><b>SM_CXMINIMIZED</b></dt>
<dt>57</dt>
</dl>
</td>
<td width="60%">
The width of a minimized window, in pixels.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXMINSPACING"></a><a id="sm_cxminspacing"></a><dl>
<dt><b>SM_CXMINSPACING</b></dt>
<dt>47</dt>
</dl>
</td>
<td width="60%">
The width of a grid cell for a minimized window, in pixels. Each minimized window fits into a rectangle
       this size when arranged. This value is always greater than or equal to SM_CXMINIMIZED.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXMINTRACK"></a><a id="sm_cxmintrack"></a><dl>
<dt><b>SM_CXMINTRACK</b></dt>
<dt>34</dt>
</dl>
</td>
<td width="60%">
The minimum tracking width of a window, in pixels. The user cannot drag the window frame to a size
       smaller than these dimensions. A window can override this value by processing the 
       <a href="https://docs.microsoft.com/windows/desktop/winmsg/wm-getminmaxinfo">WM_GETMINMAXINFO</a> message.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXPADDEDBORDER"></a><a id="sm_cxpaddedborder"></a><dl>
<dt><b>SM_CXPADDEDBORDER</b></dt>
<dt>92</dt>
</dl>
</td>
<td width="60%">
The amount of border padding for captioned windows, in pixels.

<b>Windows XP/2000:  </b>This value is not supported.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXSCREEN"></a><a id="sm_cxscreen"></a><dl>
<dt><b>SM_CXSCREEN</b></dt>
<dt>0</dt>
</dl>
</td>
<td width="60%">
The width of the screen of the primary display monitor, in pixels. This is the same value
       obtained by calling 
       <a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-getdevicecaps">GetDeviceCaps</a> as follows: <code>GetDeviceCaps(
       hdcPrimaryMonitor, HORZRES)</code>.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXSIZE"></a><a id="sm_cxsize"></a><dl>
<dt><b>SM_CXSIZE</b></dt>
<dt>30</dt>
</dl>
</td>
<td width="60%">
The width of a button in a window caption or title bar, in pixels.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXSIZEFRAME"></a><a id="sm_cxsizeframe"></a><dl>
<dt><b>SM_CXSIZEFRAME</b></dt>
<dt>32</dt>
</dl>
</td>
<td width="60%">
The thickness of the sizing border around the perimeter of a window that can be resized, in pixels.
       SM_CXSIZEFRAME is the width of the horizontal border, and SM_CYSIZEFRAME is the height of the vertical border. 
       

This value is the same as SM_CXFRAME.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXSMICON"></a><a id="sm_cxsmicon"></a><dl>
<dt><b>SM_CXSMICON</b></dt>
<dt>49</dt>
</dl>
</td>
<td width="60%">
The recommended width of a small icon, in pixels. Small icons typically appear in window captions and in
       small icon view.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXSMSIZE"></a><a id="sm_cxsmsize"></a><dl>
<dt><b>SM_CXSMSIZE</b></dt>
<dt>52</dt>
</dl>
</td>
<td width="60%">
The width of small caption buttons, in pixels.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXVIRTUALSCREEN"></a><a id="sm_cxvirtualscreen"></a><dl>
<dt><b>SM_CXVIRTUALSCREEN</b></dt>
<dt>78</dt>
</dl>
</td>
<td width="60%">
The width of the virtual screen, in pixels. The virtual screen is the bounding rectangle of all
       display monitors. The SM_XVIRTUALSCREEN metric is the coordinates for the left side of
       the virtual screen. 
       

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CXVSCROLL"></a><a id="sm_cxvscroll"></a><dl>
<dt><b>SM_CXVSCROLL</b></dt>
<dt>2</dt>
</dl>
</td>
<td width="60%">
The width of a vertical scroll bar, in pixels.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYBORDER"></a><a id="sm_cyborder"></a><dl>
<dt><b>SM_CYBORDER</b></dt>
<dt>6</dt>
</dl>
</td>
<td width="60%">
The height of a window border, in pixels. This is equivalent to the SM_CYEDGE value for 
        windows with the 3-D look.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYCAPTION"></a><a id="sm_cycaption"></a><dl>
<dt><b>SM_CYCAPTION</b></dt>
<dt>4</dt>
</dl>
</td>
<td width="60%">
The height of a caption area, in pixels.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYCURSOR"></a><a id="sm_cycursor"></a><dl>
<dt><b>SM_CYCURSOR</b></dt>
<dt>14</dt>
</dl>
</td>
<td width="60%">
The height of a cursor, in pixels. The system cannot create cursors of other sizes.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYDLGFRAME"></a><a id="sm_cydlgframe"></a><dl>
<dt><b>SM_CYDLGFRAME</b></dt>
<dt>8</dt>
</dl>
</td>
<td width="60%">
This value is the same as SM_CYFIXEDFRAME.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYDOUBLECLK"></a><a id="sm_cydoubleclk"></a><dl>
<dt><b>SM_CYDOUBLECLK</b></dt>
<dt>37</dt>
</dl>
</td>
<td width="60%">
The height of the rectangle around the location of a first click in a double-click sequence, 
        in pixels. The second click must occur within the rectangle defined by SM_CXDOUBLECLK and SM_CYDOUBLECLK for the system to consider the two 
        clicks a double-click. The two clicks must also occur within a specified time. 
        

To set the height of the double-click rectangle, call 
         <a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-systemparametersinfoa">SystemParametersInfo</a> with SPI_SETDOUBLECLKHEIGHT.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYDRAG"></a><a id="sm_cydrag"></a><dl>
<dt><b>SM_CYDRAG</b></dt>
<dt>69</dt>
</dl>
</td>
<td width="60%">
The number of pixels above and below a mouse-down point that the mouse
       pointer can move before a drag operation begins. This allows the user to click and release the
       mouse button easily without unintentionally starting a drag operation. If this value is negative, it is subtracted from above the mouse-down point and added below it. 

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYEDGE"></a><a id="sm_cyedge"></a><dl>
<dt><b>SM_CYEDGE</b></dt>
<dt>46</dt>
</dl>
</td>
<td width="60%">
The height of a 3-D border, in pixels. This is the 3-D counterpart of SM_CYBORDER.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYFIXEDFRAME"></a><a id="sm_cyfixedframe"></a><dl>
<dt><b>SM_CYFIXEDFRAME</b></dt>
<dt>8</dt>
</dl>
</td>
<td width="60%">
The thickness of the frame around the perimeter of a window that has a caption but is not sizable, in pixels.
       SM_CXFIXEDFRAME is the height of the horizontal border, and SM_CYFIXEDFRAME is the width of the vertical border.

This value is the same as SM_CYDLGFRAME.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYFOCUSBORDER"></a><a id="sm_cyfocusborder"></a><dl>
<dt><b>SM_CYFOCUSBORDER</b></dt>
<dt>84</dt>
</dl>
</td>
<td width="60%">
The height of the top and bottom edges of the focus rectangle drawn
       by 
       <a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-drawfocusrect">DrawFocusRect</a>. This value is in pixels.

<b>Windows 2000:  </b>This value is not supported.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYFRAME"></a><a id="sm_cyframe"></a><dl>
<dt><b>SM_CYFRAME</b></dt>
<dt>33</dt>
</dl>
</td>
<td width="60%">
This value is the same as SM_CYSIZEFRAME.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYFULLSCREEN"></a><a id="sm_cyfullscreen"></a><dl>
<dt><b>SM_CYFULLSCREEN</b></dt>
<dt>17</dt>
</dl>
</td>
<td width="60%">
The height of the client area for a full-screen window on the primary display monitor, in pixels. To
       get the coordinates of the portion of the screen not obscured by the system taskbar or by application desktop
       toolbars, call the 
       <a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-systemparametersinfoa">SystemParametersInfo</a> function with
       the SPI_GETWORKAREA value.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYHSCROLL"></a><a id="sm_cyhscroll"></a><dl>
<dt><b>SM_CYHSCROLL</b></dt>
<dt>3</dt>
</dl>
</td>
<td width="60%">
The height of a horizontal scroll bar, in
       pixels.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYICON"></a><a id="sm_cyicon"></a><dl>
<dt><b>SM_CYICON</b></dt>
<dt>12</dt>
</dl>
</td>
<td width="60%">
The default height of an icon, in pixels. The 
       <a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-loadicona">LoadIcon</a> function can load only icons with the
       dimensions SM_CXICON and SM_CYICON.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYICONSPACING"></a><a id="sm_cyiconspacing"></a><dl>
<dt><b>SM_CYICONSPACING</b></dt>
<dt>39</dt>
</dl>
</td>
<td width="60%">
The height of a grid cell for items in large icon view, in pixels. Each item fits into a rectangle of size SM_CXICONSPACING by SM_CYICONSPACING when arranged. This value is always greater than or equal to SM_CYICON.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYKANJIWINDOW"></a><a id="sm_cykanjiwindow"></a><dl>
<dt><b>SM_CYKANJIWINDOW</b></dt>
<dt>18</dt>
</dl>
</td>
<td width="60%">
For double byte character set versions of the system, this is the height of the Kanji window at the bottom
       of the screen, in pixels.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYMAXIMIZED"></a><a id="sm_cymaximized"></a><dl>
<dt><b>SM_CYMAXIMIZED</b></dt>
<dt>62</dt>
</dl>
</td>
<td width="60%">
The default height, in pixels, of a maximized top-level window on the primary display monitor.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYMAXTRACK"></a><a id="sm_cymaxtrack"></a><dl>
<dt><b>SM_CYMAXTRACK</b></dt>
<dt>60</dt>
</dl>
</td>
<td width="60%">
The default maximum height of a window that has a caption and sizing borders, in pixels. This metric
       refers to the entire desktop. The user cannot drag the window frame to a size larger than these dimensions. A
       window can override this value by processing the 
       <a href="https://docs.microsoft.com/windows/desktop/winmsg/wm-getminmaxinfo">WM_GETMINMAXINFO</a> message.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYMENU"></a><a id="sm_cymenu"></a><dl>
<dt><b>SM_CYMENU</b></dt>
<dt>15</dt>
</dl>
</td>
<td width="60%">
The height of a single-line menu bar, in pixels.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYMENUCHECK"></a><a id="sm_cymenucheck"></a><dl>
<dt><b>SM_CYMENUCHECK</b></dt>
<dt>72</dt>
</dl>
</td>
<td width="60%">
The height of the default menu check-mark bitmap, in pixels.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYMENUSIZE"></a><a id="sm_cymenusize"></a><dl>
<dt><b>SM_CYMENUSIZE</b></dt>
<dt>55</dt>
</dl>
</td>
<td width="60%">
The height of menu bar buttons, such as the child window close button that is used in the multiple document
       interface, in pixels.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYMIN"></a><a id="sm_cymin"></a><dl>
<dt><b>SM_CYMIN</b></dt>
<dt>29</dt>
</dl>
</td>
<td width="60%">
The minimum height of a window, in pixels.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYMINIMIZED"></a><a id="sm_cyminimized"></a><dl>
<dt><b>SM_CYMINIMIZED</b></dt>
<dt>58</dt>
</dl>
</td>
<td width="60%">
The height of a minimized window, in pixels.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYMINSPACING"></a><a id="sm_cyminspacing"></a><dl>
<dt><b>SM_CYMINSPACING</b></dt>
<dt>48</dt>
</dl>
</td>
<td width="60%">
The height of a grid cell for a minimized window, in pixels. Each minimized window fits into a rectangle
       this size when arranged. This value is always greater than or equal to SM_CYMINIMIZED.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYMINTRACK"></a><a id="sm_cymintrack"></a><dl>
<dt><b>SM_CYMINTRACK</b></dt>
<dt>35</dt>
</dl>
</td>
<td width="60%">
The minimum tracking height of a window, in pixels. The user cannot drag the window frame to a size
       smaller than these dimensions. A window can override this value by processing the 
       <a href="https://docs.microsoft.com/windows/desktop/winmsg/wm-getminmaxinfo">WM_GETMINMAXINFO</a> message.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYSCREEN"></a><a id="sm_cyscreen"></a><dl>
<dt><b>SM_CYSCREEN</b></dt>
<dt>1</dt>
</dl>
</td>
<td width="60%">
The height of the screen of the primary display monitor, in pixels. This is the same value
       obtained by calling 
       <a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-getdevicecaps">GetDeviceCaps</a> as follows: <code>GetDeviceCaps(
       hdcPrimaryMonitor, VERTRES)</code>.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYSIZE"></a><a id="sm_cysize"></a><dl>
<dt><b>SM_CYSIZE</b></dt>
<dt>31</dt>
</dl>
</td>
<td width="60%">
The height of a button in a window caption or title bar, in pixels.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYSIZEFRAME"></a><a id="sm_cysizeframe"></a><dl>
<dt><b>SM_CYSIZEFRAME</b></dt>
<dt>33</dt>
</dl>
</td>
<td width="60%">
The thickness of the sizing border around the perimeter of a window that can be resized, in pixels.
       SM_CXSIZEFRAME is the width of the horizontal border, and SM_CYSIZEFRAME is the height of the vertical border. 
       

This value is the same as SM_CYFRAME.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYSMCAPTION"></a><a id="sm_cysmcaption"></a><dl>
<dt><b>SM_CYSMCAPTION</b></dt>
<dt>51</dt>
</dl>
</td>
<td width="60%">
The height of a small caption, in pixels.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYSMICON"></a><a id="sm_cysmicon"></a><dl>
<dt><b>SM_CYSMICON</b></dt>
<dt>50</dt>
</dl>
</td>
<td width="60%">
The recommended height of a small icon, in pixels. Small icons typically appear in window captions and in
       small icon view.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYSMSIZE"></a><a id="sm_cysmsize"></a><dl>
<dt><b>SM_CYSMSIZE</b></dt>
<dt>53</dt>
</dl>
</td>
<td width="60%">
The height of small caption buttons, in pixels.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYVIRTUALSCREEN"></a><a id="sm_cyvirtualscreen"></a><dl>
<dt><b>SM_CYVIRTUALSCREEN</b></dt>
<dt>79</dt>
</dl>
</td>
<td width="60%">
The height of the virtual screen, in pixels. The virtual screen is the bounding rectangle of all
       display monitors. The SM_YVIRTUALSCREEN metric is the coordinates for the top of
       the virtual screen.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYVSCROLL"></a><a id="sm_cyvscroll"></a><dl>
<dt><b>SM_CYVSCROLL</b></dt>
<dt>20</dt>
</dl>
</td>
<td width="60%">
The height of the arrow bitmap on a vertical scroll bar, in
       pixels.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_CYVTHUMB"></a><a id="sm_cyvthumb"></a><dl>
<dt><b>SM_CYVTHUMB</b></dt>
<dt>9</dt>
</dl>
</td>
<td width="60%">
The height of the thumb box in a vertical scroll bar, in pixels.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_DBCSENABLED"></a><a id="sm_dbcsenabled"></a><dl>
<dt><b>SM_DBCSENABLED</b></dt>
<dt>42</dt>
</dl>
</td>
<td width="60%">
Nonzero if User32.dll supports DBCS; otherwise, 0.
        
       

</td>
</tr>
<tr>
<td width="40%"><a id="SM_DEBUG"></a><a id="sm_debug"></a><dl>
<dt><b>SM_DEBUG</b></dt>
<dt>22</dt>
</dl>
</td>
<td width="60%">
Nonzero if the debug version of User.exe is installed; otherwise, 0.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_DIGITIZER"></a><a id="sm_digitizer"></a><dl>
<dt><b>SM_DIGITIZER</b></dt>
<dt>94</dt>
</dl>
</td>
<td width="60%">
Nonzero  if the current operating system is Windows 7  or Windows Server 2008 R2 and the Tablet PC Input service is started; otherwise, 0. The return value is a bitmask that specifies the type of digitizer input supported by the device. For more information, see Remarks.

<b>Windows Server 2008, Windows Vista and Windows XP/2000:  </b>This value  is not supported.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_IMMENABLED"></a><a id="sm_immenabled"></a><dl>
<dt><b>SM_IMMENABLED</b></dt>
<dt>82</dt>
</dl>
</td>
<td width="60%">
Nonzero if Input Method Manager/Input Method Editor features are enabled; otherwise, 0.

SM_IMMENABLED indicates whether the system is ready to use a Unicode-based IME on a Unicode application. 
         To ensure that a language-dependent IME works, check SM_DBCSENABLED and the system ANSI code page. 
         Otherwise the ANSI-to-Unicode conversion may not be performed correctly, or some components like fonts 
         or registry settings may not be present.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_MAXIMUMTOUCHES"></a><a id="sm_maximumtouches"></a><dl>
<dt><b>SM_MAXIMUMTOUCHES</b></dt>
<dt>95</dt>
</dl>
</td>
<td width="60%">
Nonzero if there are digitizers in the system; otherwise, 0. 

SM_MAXIMUMTOUCHES returns the aggregate maximum of the maximum number of contacts supported by every digitizer in the system.  If the system has only single-touch digitizers, the return value is 1. If the system has  multi-touch digitizers, the return value is the number of simultaneous contacts the hardware can provide.

<b>Windows Server 2008, Windows Vista and Windows XP/2000:  </b>This value is not supported.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_MEDIACENTER"></a><a id="sm_mediacenter"></a><dl>
<dt><b>SM_MEDIACENTER</b></dt>
<dt>87</dt>
</dl>
</td>
<td width="60%">
Nonzero if the current operating system is the Windows XP, Media Center Edition, 0 if not.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_MENUDROPALIGNMENT"></a><a id="sm_menudropalignment"></a><dl>
<dt><b>SM_MENUDROPALIGNMENT</b></dt>
<dt>40</dt>
</dl>
</td>
<td width="60%">
Nonzero if drop-down menus are right-aligned with the corresponding menu-bar item; 0 if the menus are
       left-aligned.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_MIDEASTENABLED"></a><a id="sm_mideastenabled"></a><dl>
<dt><b>SM_MIDEASTENABLED</b></dt>
<dt>74</dt>
</dl>
</td>
<td width="60%">
Nonzero if the system is enabled for Hebrew and Arabic languages, 0 if not.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_MOUSEPRESENT"></a><a id="sm_mousepresent"></a><dl>
<dt><b>SM_MOUSEPRESENT</b></dt>
<dt>19</dt>
</dl>
</td>
<td width="60%">
Nonzero if a mouse is installed; otherwise, 0. This value is rarely zero, because of support for virtual mice and because some systems detect the presence of the port instead of the presence of a mouse.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_MOUSEHORIZONTALWHEELPRESENT"></a><a id="sm_mousehorizontalwheelpresent"></a><dl>
<dt><b>SM_MOUSEHORIZONTALWHEELPRESENT</b></dt>
<dt>91</dt>
</dl>
</td>
<td width="60%">
Nonzero if a mouse with a horizontal scroll wheel is installed; otherwise 0.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_MOUSEWHEELPRESENT"></a><a id="sm_mousewheelpresent"></a><dl>
<dt><b>SM_MOUSEWHEELPRESENT</b></dt>
<dt>75</dt>
</dl>
</td>
<td width="60%">
Nonzero if a mouse with a vertical scroll wheel is installed; otherwise 0.
       

</td>
</tr>
<tr>
<td width="40%"><a id="SM_NETWORK"></a><a id="sm_network"></a><dl>
<dt><b>SM_NETWORK</b></dt>
<dt>63</dt>
</dl>
</td>
<td width="60%">
The least significant bit is set if a network is present; otherwise, it is cleared. The other bits are
       reserved for future use.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_PENWINDOWS"></a><a id="sm_penwindows"></a><dl>
<dt><b>SM_PENWINDOWS</b></dt>
<dt>41</dt>
</dl>
</td>
<td width="60%">
Nonzero if the Microsoft Windows for Pen computing extensions are installed; zero otherwise.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_REMOTECONTROL"></a><a id="sm_remotecontrol"></a><dl>
<dt><b>SM_REMOTECONTROL</b></dt>
<dt>0x2001</dt>
</dl>
</td>
<td width="60%">
This system metric is used in a Terminal Services environment to determine if the current Terminal Server session is being remotely controlled. Its value is nonzero if the current 
        session is remotely controlled; otherwise, 0.

You can use terminal services management tools such as Terminal Services Manager (tsadmin.msc) and shadow.exe to control a remote session. When a session is being remotely controlled, another user can view the contents of that session and potentially interact with it.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_REMOTESESSION"></a><a id="sm_remotesession"></a><dl>
<dt><b>SM_REMOTESESSION</b></dt>
<dt>0x1000</dt>
</dl>
</td>
<td width="60%">
This system metric is used in a Terminal Services environment. If the calling process is associated 
        with a Terminal Services client session, the return value is nonzero. If the calling process is 
        associated with the Terminal Services console session, the return value is 0. <b>Windows Server 2003 and Windows XP:  </b>The console session
        is not necessarily the physical console. For more information, see <a href="https://docs.microsoft.com/windows/desktop/api/winbase/nf-winbase-wtsgetactiveconsolesessionid">WTSGetActiveConsoleSessionId</a>.



</td>
</tr>
<tr>
<td width="40%"><a id="SM_SAMEDISPLAYFORMAT"></a><a id="sm_samedisplayformat"></a><dl>
<dt><b>SM_SAMEDISPLAYFORMAT</b></dt>
<dt>81</dt>
</dl>
</td>
<td width="60%">
Nonzero if all the display monitors have the same color format, otherwise, 0. Two 
        displays can have the same bit depth, but different color formats. For example, the red, green, 
        and blue pixels can be encoded with different numbers of bits, or those bits can be located in 
        different places in a pixel color value.
        
       

</td>
</tr>
<tr>
<td width="40%"><a id="SM_SECURE"></a><a id="sm_secure"></a><dl>
<dt><b>SM_SECURE</b></dt>
<dt>44</dt>
</dl>
</td>
<td width="60%">
This system metric should be ignored; it always returns 0.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_SERVERR2"></a><a id="sm_serverr2"></a><dl>
<dt><b>SM_SERVERR2</b></dt>
<dt>89</dt>
</dl>
</td>
<td width="60%">
The build number if the system is Windows Server 2003 R2; otherwise, 0.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_SHOWSOUNDS"></a><a id="sm_showsounds"></a><dl>
<dt><b>SM_SHOWSOUNDS</b></dt>
<dt>70</dt>
</dl>
</td>
<td width="60%">
Nonzero if the user requires an application to present information visually in situations 
        where it would otherwise present the information only in audible form; otherwise, 0.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_SHUTTINGDOWN"></a><a id="sm_shuttingdown"></a><dl>
<dt><b>SM_SHUTTINGDOWN</b></dt>
<dt>0x2000</dt>
</dl>
</td>
<td width="60%">
Nonzero if the current session is shutting down; otherwise, 0.
        

<b>Windows 2000:  </b>This value is not supported.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_SLOWMACHINE"></a><a id="sm_slowmachine"></a><dl>
<dt><b>SM_SLOWMACHINE</b></dt>
<dt>73</dt>
</dl>
</td>
<td width="60%">
Nonzero if the computer has a low-end (slow) processor; otherwise, 0.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_STARTER"></a><a id="sm_starter"></a><dl>
<dt><b>SM_STARTER</b></dt>
<dt>88</dt>
</dl>
</td>
<td width="60%">
Nonzero if the current operating system is Windows 7 Starter Edition, Windows Vista Starter, or Windows XP Starter Edition; otherwise, 0.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_SWAPBUTTON"></a><a id="sm_swapbutton"></a><dl>
<dt><b>SM_SWAPBUTTON</b></dt>
<dt>23</dt>
</dl>
</td>
<td width="60%">
Nonzero if the meanings of the left and right mouse buttons are swapped; otherwise, 0.

</td>
</tr>
<tr>
<td width="40%"><a id="SM_SYSTEMDOCKED_"></a><a id="sm_systemdocked_"></a><dl>
<dt><b>SM_SYSTEMDOCKED
</b></dt>
<dt>0x2004</dt>
</dl>
</td>
<td width="60%">
Reflects the state of the docking mode, 0 for Undocked Mode and non-zero otherwise. When this system metric changes, the system sends a broadcast message via <a href="https://docs.microsoft.com/windows/desktop/winmsg/wm-settingchange">WM_SETTINGCHANGE</a> with "SystemDockMode" in the LPARAM.



</td>
</tr>
<tr>
<td width="40%"><a id="SM_TABLETPC"></a><a id="sm_tabletpc"></a><dl>
<dt><b>SM_TABLETPC</b></dt>
<dt>86</dt>
</dl>
</td>
<td width="60%">
Nonzero if the current operating system is the Windows XP Tablet PC edition or if the current operating system is Windows Vista or Windows 7 and the Tablet PC Input service is started; otherwise, 0. The SM_DIGITIZER setting indicates the type of digitizer input supported by a device running Windows 7 or Windows Server 2008 R2. For more information, see Remarks. 

</td>
</tr>
<tr>
<td width="40%"><a id="SM_XVIRTUALSCREEN"></a><a id="sm_xvirtualscreen"></a><dl>
<dt><b>SM_XVIRTUALSCREEN</b></dt>
<dt>76</dt>
</dl>
</td>
<td width="60%">
The coordinates for the left side of the virtual screen. The virtual screen is the bounding
        rectangle of all display monitors. The SM_CXVIRTUALSCREEN metric is the width 
        of the virtual screen.
        
       

</td>
</tr>
<tr>
<td width="40%"><a id="SM_YVIRTUALSCREEN"></a><a id="sm_yvirtualscreen"></a><dl>
<dt><b>SM_YVIRTUALSCREEN</b></dt>
<dt>77</dt>
</dl>
</td>
<td width="60%">
The coordinates for the top of the virtual screen. The virtual screen is the bounding
        rectangle of all display monitors. The SM_CYVIRTUALSCREEN metric is the height of the virtual screen.
        
       

</td>
</tr>
</table>
 


## -returns



Type: <strong>Type: <b>int</b>
</strong>

If the function succeeds, the return value is the requested system metric or configuration setting.

If the function fails, the return value is 0. 
       <a href="https://docs.microsoft.com/windows/desktop/api/errhandlingapi/nf-errhandlingapi-getlasterror">GetLastError</a> does not provide extended error information.
      




## -remarks



System metrics can vary from display to display.

<b>GetSystemMetrics</b>(SM_CMONITORS) counts only 
    visible display monitors. This is different from 
    <a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-enumdisplaymonitors">EnumDisplayMonitors</a>, which enumerates both visible display 
    monitors and invisible  pseudo-monitors that are associated with mirroring drivers. An invisible pseudo-monitor is associated with a pseudo-device used to mirror application drawing for remoting or other purposes.

The SM_ARRANGE setting specifies how the system arranges minimized windows, and consists of a starting 
    position and a direction. The starting position can be one of the following values.
   

<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td>ARW_BOTTOMLEFT</td>
<td>Start at the lower-left corner of the screen. The default position.</td>
</tr>
<tr>
<td>ARW_BOTTOMRIGHT</td>
<td>Start at the lower-right corner of the screen. Equivalent to ARW_STARTRIGHT.</td>
</tr>
<tr>
<td>ARW_TOPLEFT</td>
<td>Start at the upper-left corner of the screen. Equivalent to ARW_STARTTOP.</td>
</tr>
<tr>
<td>ARW_TOPRIGHT</td>
<td>Start at the upper-right corner of the screen. Equivalent to ARW_STARTTOP | SRW_STARTRIGHT.</td>
</tr>
</table>
 

The direction in which to arrange minimized windows can be one of the following values.

<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td>ARW_DOWN</td>
<td>Arrange vertically, top to bottom.</td>
</tr>
<tr>
<td>ARW_HIDE</td>
<td>Hide minimized windows by moving them off the visible area of the screen.</td>
</tr>
<tr>
<td>ARW_LEFT</td>
<td>Arrange horizontally, left to right.</td>
</tr>
<tr>
<td>ARW_RIGHT</td>
<td>Arrange horizontally, right to left.</td>
</tr>
<tr>
<td>ARW_UP</td>
<td>Arrange vertically, bottom to top.</td>
</tr>
</table>
 

The SM_DIGITIZER setting specifies the type of digitizers that are installed on a device running Windows 7 or Windows Server 2008 R2. The return value is a bitmask that specifies one or more of the following values.

<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td>
NID_INTEGRATED_TOUCH

0x01

</td>
<td>
The device has an integrated touch digitizer. 

</td>
</tr>
<tr>
<td>
NID_EXTERNAL_TOUCH

0x02

</td>
<td>
The device has an external touch digitizer. 

</td>
</tr>
<tr>
<td>
NID_INTEGRATED_PEN

0x04

</td>
<td>
The device has an integrated pen digitizer.

</td>
</tr>
<tr>
<td>
NID_EXTERNAL_PEN

0x08

</td>
<td>
The device has an external pen digitizer.

</td>
</tr>
<tr>
<td>
NID_MULTI_INPUT

0x40

</td>
<td>
The device supports multiple sources of digitizer input. 

</td>
</tr>
<tr>
<td>
NID_READY

0x80

</td>
<td>
The device is ready to receive digitizer input.

</td>
</tr>
</table>
 

This API is not DPI aware, and should not be used if the calling thread is per-monitor DPI aware. For the DPI-aware version of this API, see <a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-getsystemmetricsfordpi">GetSystemMetricsForDPI</a>. For more information on DPI awareness, see <a href="https://docs.microsoft.com/windows/desktop/hidpi/high-dpi-desktop-application-development-on-windows">the Windows High DPI documentation.</a>



#### Examples

The following example uses the 
<a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-getsystemmetrics">GetSystemMetrics</a> function to determine whether a mouse is installed and whether the mouse buttons are swapped. The example also uses the 
<a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-systemparametersinfoa">SystemParametersInfo</a> function to retrieve the mouse threshold and speed. It displays the information in the console.

<pre class="syntax" xml:space="preserve"><code>#include &lt;windows.h&gt;
#include &lt;stdio.h&gt;
#pragma comment(lib, "user32.lib")

void main()
{
   BOOL fResult;
   int aMouseInfo[3];
 
   fResult = GetSystemMetrics(SM_MOUSEPRESENT); 
 
   if (fResult == 0) 
      printf("No mouse installed.\n"); 
   else 
   { 
      printf("Mouse installed.\n");

      // Determine whether the buttons are swapped. 

      fResult = GetSystemMetrics(SM_SWAPBUTTON); 
 
      if (fResult == 0) 
         printf("Buttons not swapped.\n"); 
      else printf("Buttons swapped.\n");
 
      // Get the mouse speed and the threshold values. 
 
      fResult = SystemParametersInfo(
         SPI_GETMOUSE,  // get mouse information 
         0,             // not used 
         &amp;aMouseInfo,   // holds mouse information 
         0);            // not used 

      if( fResult )
      { 
         printf("Speed: %d\n", aMouseInfo[2]); 
         printf("Threshold (x,y): %d,%d\n", 
            aMouseInfo[0], aMouseInfo[1]); 
      }
   } 
}</code></pre>



## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-enumdisplaymonitors">EnumDisplayMonitors</a>



<a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-getsystemmetricsfordpi">GetSystemMetricsForDPI</a>



<a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-systemparametersinfoa">SystemParametersInfo</a>
 

 

