---
UID: NF:winuser.MessageBoxW
title: MessageBoxW function (winuser.h)
description: Displays a modal dialog box that contains a system icon, a set of buttons, and a brief application-specific message, such as status or error information. The message box returns an integer value that indicates which button the user clicked.
old-location: dlgbox\messagebox.htm
tech.root: dlgbox
ms.assetid: VS|winui|~\winui\windowsuserinterface\windowing\dialogboxes\dialogboxreference\dialogboxfunctions\messagebox.htm
ms.date: 12/05/2018
ms.keywords: MB_ABORTRETRYIGNORE, MB_APPLMODAL, MB_CANCELTRYCONTINUE, MB_DEFAULT_DESKTOP_ONLY, MB_DEFBUTTON1, MB_DEFBUTTON2, MB_DEFBUTTON3, MB_DEFBUTTON4, MB_HELP, MB_ICONASTERISK, MB_ICONERROR, MB_ICONEXCLAMATION, MB_ICONHAND, MB_ICONINFORMATION, MB_ICONQUESTION, MB_ICONSTOP, MB_ICONWARNING, MB_OK, MB_OKCANCEL, MB_RETRYCANCEL, MB_RIGHT, MB_RTLREADING, MB_SERVICE_NOTIFICATION, MB_SETFOREGROUND, MB_SYSTEMMODAL, MB_TASKMODAL, MB_TOPMOST, MB_YESNO, MB_YESNOCANCEL, MessageBox, MessageBox function [Dialog Boxes], MessageBoxA, MessageBoxW, _win32_MessageBox, _win32_messagebox_cpp, dlgbox.messagebox, winui._win32_messagebox, winuser/MessageBox, winuser/MessageBoxA, winuser/MessageBoxW
f1_keywords:
- winuser/MessageBox
dev_langs:
- c++
req.header: winuser.h
req.include-header: Windows.h
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: MessageBoxW (Unicode) and MessageBoxA (ANSI)
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: User32.lib
req.dll: User32.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- User32.dll
- Ext-MS-Win-NTUser-DialogBox-l1-1-0.dll
- Ext-MS-Win-NTUser-DialogBox-l1-1-1.dll
- ext-ms-win-ntuser-dialogbox-l1-1-2.dll
api_name:
- MessageBox
- MessageBoxA
- MessageBoxW
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# MessageBoxW function


## -description


Displays a modal dialog box that contains a system icon, a set of buttons, and a brief application-specific message, such as status or error information. The message box returns an integer value that indicates which button the user clicked.


## -parameters




### -param hWnd [in, optional]

Type: <b>HWND</b>

A handle to the owner window of the message box to be created. If this parameter is <b>NULL</b>, the message box has no owner window.


### -param lpText [in, optional]

Type: <b>LPCTSTR</b>

The message to be displayed. If the string consists of more than one line, you can separate the lines using a carriage return and/or linefeed character between each line.


### -param lpCaption [in, optional]

Type: <b>LPCTSTR</b>

The dialog box title. If this parameter is <b>NULL</b>, the default title is <b>Error</b>.


### -param uType [in]

Type: <b>UINT</b>

The contents and behavior of the dialog box. This parameter can be a combination of flags from the following groups of flags.


To indicate the buttons displayed in the message box, specify one of the following values.



<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="MB_ABORTRETRYIGNORE"></a><a id="mb_abortretryignore"></a><dl>
<dt><b>MB_ABORTRETRYIGNORE</b></dt>
<dt>0x00000002L</dt>
</dl>
</td>
<td width="60%">
The message box contains three push buttons: <b>Abort</b>, <b>Retry</b>, and <b>Ignore</b>.

</td>
</tr>
<tr>
<td width="40%"><a id="MB_CANCELTRYCONTINUE"></a><a id="mb_canceltrycontinue"></a><dl>
<dt><b>MB_CANCELTRYCONTINUE</b></dt>
<dt>0x00000006L</dt>
</dl>
</td>
<td width="60%">
 The message box contains three push buttons: <b>Cancel</b>, <b>Try Again</b>, <b>Continue</b>. Use this message box type instead of MB_ABORTRETRYIGNORE.

</td>
</tr>
<tr>
<td width="40%"><a id="MB_HELP"></a><a id="mb_help"></a><dl>
<dt><b>MB_HELP</b></dt>
<dt>0x00004000L</dt>
</dl>
</td>
<td width="60%">
 Adds a <b>Help</b> button to the message box. When the user clicks the <b>Help</b> button or presses F1, the system sends a <a href="https://docs.microsoft.com/windows/desktop/shell/wm-help">WM_HELP</a> message to the owner.

</td>
</tr>
<tr>
<td width="40%"><a id="MB_OK"></a><a id="mb_ok"></a><dl>
<dt><b>MB_OK</b></dt>
<dt>0x00000000L</dt>
</dl>
</td>
<td width="60%">
The message box contains one push button: <b>OK</b>. This is the default.

</td>
</tr>
<tr>
<td width="40%"><a id="MB_OKCANCEL"></a><a id="mb_okcancel"></a><dl>
<dt><b>MB_OKCANCEL</b></dt>
<dt>0x00000001L</dt>
</dl>
</td>
<td width="60%">
The message box contains two push buttons: <b>OK</b> and <b>Cancel</b>.

</td>
</tr>
<tr>
<td width="40%"><a id="MB_RETRYCANCEL"></a><a id="mb_retrycancel"></a><dl>
<dt><b>MB_RETRYCANCEL</b></dt>
<dt>0x00000005L</dt>
</dl>
</td>
<td width="60%">
The message box contains two push buttons: <b>Retry</b> and <b>Cancel</b>.

</td>
</tr>
<tr>
<td width="40%"><a id="MB_YESNO"></a><a id="mb_yesno"></a><dl>
<dt><b>MB_YESNO</b></dt>
<dt>0x00000004L</dt>
</dl>
</td>
<td width="60%">
The message box contains two push buttons: <b>Yes</b> and <b>No</b>.

</td>
</tr>
<tr>
<td width="40%"><a id="MB_YESNOCANCEL"></a><a id="mb_yesnocancel"></a><dl>
<dt><b>MB_YESNOCANCEL</b></dt>
<dt>0x00000003L</dt>
</dl>
</td>
<td width="60%">
The message box contains three push buttons: <b>Yes</b>, <b>No</b>, and <b>Cancel</b>.

</td>
</tr>
</table>
 


To display an icon in the message box, specify one of the following values.



<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="MB_ICONEXCLAMATION"></a><a id="mb_iconexclamation"></a><dl>
<dt><b>MB_ICONEXCLAMATION</b></dt>
<dt>0x00000030L</dt>
</dl>
</td>
<td width="60%">
An exclamation-point icon appears in the message box.

</td>
</tr>
<tr>
<td width="40%"><a id="MB_ICONWARNING"></a><a id="mb_iconwarning"></a><dl>
<dt><b>MB_ICONWARNING</b></dt>
<dt>0x00000030L</dt>
</dl>
</td>
<td width="60%">
An exclamation-point icon appears in the message box.

</td>
</tr>
<tr>
<td width="40%"><a id="MB_ICONINFORMATION"></a><a id="mb_iconinformation"></a><dl>
<dt><b>MB_ICONINFORMATION</b></dt>
<dt>0x00000040L</dt>
</dl>
</td>
<td width="60%">
An icon consisting of a lowercase letter <i>i</i> in a circle appears in the message box.

</td>
</tr>
<tr>
<td width="40%"><a id="MB_ICONASTERISK"></a><a id="mb_iconasterisk"></a><dl>
<dt><b>MB_ICONASTERISK</b></dt>
<dt>0x00000040L</dt>
</dl>
</td>
<td width="60%">
An icon consisting of a lowercase letter <i>i</i> in a circle appears in the message box.

</td>
</tr>
<tr>
<td width="40%"><a id="MB_ICONQUESTION"></a><a id="mb_iconquestion"></a><dl>
<dt><b>MB_ICONQUESTION</b></dt>
<dt>0x00000020L</dt>
</dl>
</td>
<td width="60%">
A question-mark icon appears in the message box. The question-mark message icon is no longer recommended because it does not clearly represent a specific type of message and because the phrasing of a message as a question could apply to any message type. In addition, users can confuse the message symbol question mark with Help information. Therefore, do not use this question mark message symbol in your message boxes. The system continues to support its inclusion only for backward compatibility.

</td>
</tr>
<tr>
<td width="40%"><a id="MB_ICONSTOP"></a><a id="mb_iconstop"></a><dl>
<dt><b>MB_ICONSTOP</b></dt>
<dt>0x00000010L</dt>
</dl>
</td>
<td width="60%">
A stop-sign icon appears in the message box.

</td>
</tr>
<tr>
<td width="40%"><a id="MB_ICONERROR"></a><a id="mb_iconerror"></a><dl>
<dt><b>MB_ICONERROR</b></dt>
<dt>0x00000010L</dt>
</dl>
</td>
<td width="60%">
A stop-sign icon appears in the message box.

</td>
</tr>
<tr>
<td width="40%"><a id="MB_ICONHAND"></a><a id="mb_iconhand"></a><dl>
<dt><b>MB_ICONHAND</b></dt>
<dt>0x00000010L</dt>
</dl>
</td>
<td width="60%">
A stop-sign icon appears in the message box.

</td>
</tr>
</table>
 


To indicate the default button, specify one of the following values.



<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="MB_DEFBUTTON1"></a><a id="mb_defbutton1"></a><dl>
<dt><b>MB_DEFBUTTON1</b></dt>
<dt>0x00000000L</dt>
</dl>
</td>
<td width="60%">
The first button is the default button.

<b>MB_DEFBUTTON1</b> is the default unless <b>MB_DEFBUTTON2</b>, <b>MB_DEFBUTTON3</b>, or <b>MB_DEFBUTTON4</b> is specified.

</td>
</tr>
<tr>
<td width="40%"><a id="MB_DEFBUTTON2"></a><a id="mb_defbutton2"></a><dl>
<dt><b>MB_DEFBUTTON2</b></dt>
<dt>0x00000100L</dt>
</dl>
</td>
<td width="60%">
The second button is the default button.

</td>
</tr>
<tr>
<td width="40%"><a id="MB_DEFBUTTON3"></a><a id="mb_defbutton3"></a><dl>
<dt><b>MB_DEFBUTTON3</b></dt>
<dt>0x00000200L</dt>
</dl>
</td>
<td width="60%">
The third button is the default button.

</td>
</tr>
<tr>
<td width="40%"><a id="MB_DEFBUTTON4"></a><a id="mb_defbutton4"></a><dl>
<dt><b>MB_DEFBUTTON4</b></dt>
<dt>0x00000300L</dt>
</dl>
</td>
<td width="60%">
The fourth button is the default button.

</td>
</tr>
</table>
 


To indicate the modality of the dialog box, specify one of the following values.



<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="MB_APPLMODAL"></a><a id="mb_applmodal"></a><dl>
<dt><b>MB_APPLMODAL</b></dt>
<dt>0x00000000L</dt>
</dl>
</td>
<td width="60%">
The user must respond to the message box before continuing work in the window identified by the <i>hWnd</i> parameter. However, the user can move to the windows of other threads and work in those windows.
							
                            

Depending on the hierarchy of windows in the application, the user may be able to move to other windows within the thread. All child windows of the parent of the message box are automatically disabled, but pop-up windows are not.

<b>MB_APPLMODAL</b> is the default if neither <b>MB_SYSTEMMODAL</b> nor <b>MB_TASKMODAL</b> is specified.

</td>
</tr>
<tr>
<td width="40%"><a id="MB_SYSTEMMODAL"></a><a id="mb_systemmodal"></a><dl>
<dt><b>MB_SYSTEMMODAL</b></dt>
<dt>0x00001000L</dt>
</dl>
</td>
<td width="60%">
Same as MB_APPLMODAL except that the message box has the <b>WS_EX_TOPMOST</b> style. Use system-modal message boxes to notify the user of serious, potentially damaging errors that require immediate attention (for example, running out of memory). This flag has no effect on the user's ability to interact with windows other than those associated with <i>hWnd</i>.

</td>
</tr>
<tr>
<td width="40%"><a id="MB_TASKMODAL"></a><a id="mb_taskmodal"></a><dl>
<dt><b>MB_TASKMODAL</b></dt>
<dt>0x00002000L</dt>
</dl>
</td>
<td width="60%">
Same as <b>MB_APPLMODAL</b> except that all the top-level windows belonging to the current thread are disabled if the <i>hWnd</i> parameter is <b>NULL</b>. Use this flag when the calling application or library does not have a window handle available but still needs to prevent input to other windows in the calling thread without suspending other threads.

</td>
</tr>
</table>
 


To specify other options, use one or more of the following values.



<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="MB_DEFAULT_DESKTOP_ONLY"></a><a id="mb_default_desktop_only"></a><dl>
<dt><b>MB_DEFAULT_DESKTOP_ONLY</b></dt>
<dt>0x00020000L</dt>
</dl>
</td>
<td width="60%">
 Same as desktop of the interactive window station. For more information, see <a href="https://docs.microsoft.com/windows/desktop/winstation/window-stations">Window Stations</a>.
					
                    		
					
                    		

 If the current input desktop is not the default desktop, <b>MessageBox</b> does not return until the user switches to the default desktop.

</td>
</tr>
<tr>
<td width="40%"><a id="MB_RIGHT"></a><a id="mb_right"></a><dl>
<dt><b>MB_RIGHT</b></dt>
<dt>0x00080000L</dt>
</dl>
</td>
<td width="60%">
The text is right-justified.

</td>
</tr>
<tr>
<td width="40%"><a id="MB_RTLREADING"></a><a id="mb_rtlreading"></a><dl>
<dt><b>MB_RTLREADING</b></dt>
<dt>0x00100000L</dt>
</dl>
</td>
<td width="60%">
Displays message and caption text using right-to-left reading order on Hebrew and Arabic systems.

</td>
</tr>
<tr>
<td width="40%"><a id="MB_SETFOREGROUND"></a><a id="mb_setforeground"></a><dl>
<dt><b>MB_SETFOREGROUND</b></dt>
<dt>0x00010000L</dt>
</dl>
</td>
<td width="60%">
The message box becomes the foreground window. Internally, the system calls the <a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-setforegroundwindow">SetForegroundWindow</a> function for the message box.

</td>
</tr>
<tr>
<td width="40%"><a id="MB_TOPMOST"></a><a id="mb_topmost"></a><dl>
<dt><b>MB_TOPMOST</b></dt>
<dt>0x00040000L</dt>
</dl>
</td>
<td width="60%">
The message box is created with the <b>WS_EX_TOPMOST</b> window style.

</td>
</tr>
<tr>
<td width="40%"><a id="MB_SERVICE_NOTIFICATION"></a><a id="mb_service_notification"></a><dl>
<dt><b>MB_SERVICE_NOTIFICATION</b></dt>
<dt>0x00200000L</dt>
</dl>
</td>
<td width="60%">
The caller is a service notifying the user of an event. The function displays a message box on the current active desktop, even if there is no user logged on to the computer.

<b>Terminal Services:</b> If the calling thread has an impersonation token, the function directs the message box to the session specified in the impersonation token.

If this flag is set, the <i>hWnd</i> parameter must be <b>NULL</b>. This is so that the message box can appear on a desktop other than the desktop corresponding to the <i>hWnd</i>.

For information on security considerations in regard to using this flag, see <a href="https://docs.microsoft.com/windows/desktop/Services/interactive-services">Interactive Services</a>. In particular, be aware that this flag can produce interactive content on a locked desktop and should therefore be used for only a very limited set of scenarios, such as resource exhaustion.

</td>
</tr>
</table>
 


## -returns



Type: <b>int</b>

If a message box has a <b>Cancel</b> button, the function returns the <b>IDCANCEL</b> value if either the ESC key is pressed or the <b>Cancel</b> button is selected. If the message box has no <b>Cancel</b> button, pressing ESC has no effect.

If the function fails, the return value is zero. To get extended error information, call <a href="https://docs.microsoft.com/windows/desktop/api/errhandlingapi/nf-errhandlingapi-getlasterror">GetLastError</a>.

If the function succeeds, the return value is one of the following menu-item values.

<table>
<tr>
<th>Return code/value</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>IDABORT</b></dt>
<dt>3</dt>
</dl>
</td>
<td width="60%">
The <b>Abort</b> button was selected.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>IDCANCEL</b></dt>
<dt>2</dt>
</dl>
</td>
<td width="60%">
The <b>Cancel</b> button was selected.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>IDCONTINUE</b></dt>
<dt>11</dt>
</dl>
</td>
<td width="60%">
The <b>Continue</b> button was selected.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>IDIGNORE</b></dt>
<dt>5</dt>
</dl>
</td>
<td width="60%">
The <b>Ignore</b> button was selected.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>IDNO</b></dt>
<dt>7</dt>
</dl>
</td>
<td width="60%">
The <b>No</b> button was selected.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>IDOK</b></dt>
<dt>1</dt>
</dl>
</td>
<td width="60%">
The <b>OK</b> button was selected.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>IDRETRY</b></dt>
<dt>4</dt>
</dl>
</td>
<td width="60%">
The <b>Retry</b> button was selected.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>IDTRYAGAIN</b></dt>
<dt>10</dt>
</dl>
</td>
<td width="60%">
The <b>Try Again</b> button was selected.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>IDYES</b></dt>
<dt>6</dt>
</dl>
</td>
<td width="60%">
The <b>Yes</b> button was selected.

</td>
</tr>
</table>
 




## -remarks



The following system icons can be used in a message box by setting the <i>uType</i> parameter to the corresponding flag value.

<table class="clsStd">
<tr>
<th>Icon</th>
<th>Flag values</th>
</tr>
<tr>
<td><img alt="Icon for MB_ICONHAND, MB_ICONSTOP, and MB_ICONERROR" src="./images/MB_ICONHAND.png"/></td>
<td><b>MB_ICONHAND</b>, <b>MB_ICONSTOP</b>, or <b>MB_ICONERROR</b></td>
</tr>
<tr>
<td><img alt="Icon for MB_ICONQUESTION" src="./images/MB_ICONQUESTION.png"/></td>
<td><b>MB_ICONQUESTION</b></td>
</tr>
<tr>
<td><img alt="Icon for MB_ICONEXCLAMATION and MB_ICONWARNING" src="./images/MB_ICONEXCLAMATION.png"/></td>
<td><b>MB_ICONEXCLAMATION</b> or <b>MB_ICONWARNING</b></td>
</tr>
<tr>
<td><img alt="Icon for MB_ICONASTERISK and MB_ICONINFORMATION" src="./images/MB_ICONASTERISK.png"/></td>
<td><b>MB_ICONASTERISK</b> or <b>MB_ICONINFORMATION</b></td>
</tr>
</table>
 

Adding two right-to-left marks (RLMs), represented by Unicode formatting character U+200F, in the beginning of a MessageBox display string is interpreted by the MessageBox rendering engine so as to cause the reading order of the MessageBox to be rendered as right-to-left (RTL).

When you use a system-modal message box to indicate that the system is low on memory, the strings pointed to by the <i>lpText</i> and <i>lpCaption</i> parameters should not be taken from a resource file because an attempt to load the resource may fail.

If you create a message box while a dialog box is present, use a handle to the dialog box as the <i>hWnd</i> parameter. The <i>hWnd</i> parameter should not identify a child window, such as a control in a dialog box.


#### Examples

In the following example, the application displays a message box that prompts the user for an action after an error condition has occurred. The message box displays the message that describes the error condition and how to resolve it. The <b>MB_CANCELTRYCONTINUE</b> style directs <b>MessageBox</b> to provide three buttons with which the user can choose how to proceed. The <b>MB_DEFBUTTON2</b> style sets the default focus on the second button of the message box, in this case, the <b>Try Again</b> button.


```cpp
int DisplayResourceNAMessageBox()
{
    int msgboxID = MessageBox(
        NULL,
        (LPCWSTR)L"Resource not available\nDo you want to try again?",
        (LPCWSTR)L"Account Details",
        MB_ICONWARNING | MB_CANCELTRYCONTINUE | MB_DEFBUTTON2
    );

    switch (msgboxID)
    {
    case IDCANCEL:
        // TODO: add code
        break;
    case IDTRYAGAIN:
        // TODO: add code
        break;
    case IDCONTINUE:
        // TODO: add code
        break;
    }

    return msgboxID;
}
```


The following image shows the output from the preceding code example:

<img alt="Message box" src="./images/MessageBox_02.png"/>

For another message box example, see <a href="https://docs.microsoft.com/windows/desktop/dlgbox/using-dialog-boxes">Displaying a Message Box</a>.




## -see-also




<b>Conceptual</b>



<a href="https://docs.microsoft.com/windows/desktop/dlgbox/dialog-boxes">Dialog Boxes</a>



<a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-flashwindow">FlashWindow</a>



<a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-messagebeep">MessageBeep</a>



<a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-messageboxexa">MessageBoxEx</a>



<a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-messageboxindirecta">MessageBoxIndirect</a>



<b>Other Resources</b>



<b>Reference</b>



<a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-setforegroundwindow">SetForegroundWindow</a>
 

 

