---
UID: NF:winuser.POINTSTOPOINT
title: POINTSTOPOINT macro (winuser.h)
description: The POINTSTOPOINT macro copies the contents of a POINTS structure into a POINT structure.
old-location: gdi\pointstopoint.htm
tech.root: gdi
ms.assetid: 921da8a5-cd8a-4851-b470-9b7bd10afaad
ms.date: 12/05/2018
ms.keywords: POINTSTOPOINT, POINTSTOPOINT macro [Windows GDI], _win32_POINTSTOPOINT, gdi.pointstopoint, winuser/POINTSTOPOINT
f1_keywords:
- winuser/POINTSTOPOINT
dev_langs:
- c++
req.header: winuser.h
req.include-header: Windows.h
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Winuser.h
api_name:
- POINTSTOPOINT
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# POINTSTOPOINT macro


## -description



The <b>POINTSTOPOINT</b> macro copies the contents of a <a href="https://docs.microsoft.com/previous-versions/dd162808(v=vs.85)">POINTS</a> structure into a <a href="https://docs.microsoft.com/previous-versions/dd162805(v=vs.85)">POINT</a> structure.




## -parameters




### -param pt

The <a href="https://docs.microsoft.com/previous-versions/dd162805(v=vs.85)">POINT</a> structure to receive the contents of the <a href="https://docs.microsoft.com/previous-versions/dd162808(v=vs.85)">POINTS</a> structure.


### -param pts

The <a href="https://docs.microsoft.com/previous-versions/dd162808(v=vs.85)">POINTS</a> structure to copy.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-makepoints">MAKEPOINTS</a>



<a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-pointtopoints">POINTTOPOINTS</a>



<a href="https://docs.microsoft.com/windows/desktop/gdi/rectangle-macros">Rectangle Macros</a>



<a href="https://docs.microsoft.com/windows/desktop/gdi/rectangles">Rectangles Overview</a>
 

 

