---
UID: NF:winuser.POINTTOPOINTS
title: POINTTOPOINTS macro (winuser.h)
description: The POINTTOPOINTS macro converts a POINT structure to a POINTS structure.
old-location: gdi\pointtopoints.htm
tech.root: gdi
ms.assetid: 9e9ec2c0-fce6-4205-8299-20ef7ff154e9
ms.date: 12/05/2018
ms.keywords: POINTTOPOINTS, POINTTOPOINTS macro [Windows GDI], _win32_POINTTOPOINTS, gdi.pointtopoints, winuser/POINTTOPOINTS
f1_keywords:
- winuser/POINTTOPOINTS
dev_langs:
- c++
req.header: winuser.h
req.include-header: Windows.h
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Winuser.h
api_name:
- POINTTOPOINTS
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# POINTTOPOINTS macro


## -description



The <b>POINTTOPOINTS</b> macro converts a <a href="https://docs.microsoft.com/previous-versions/dd162805(v=vs.85)">POINT</a> structure to a <a href="https://docs.microsoft.com/previous-versions/dd162808(v=vs.85)">POINTS</a> structure.




## -parameters




### -param pt

The <a href="https://docs.microsoft.com/previous-versions/dd162805(v=vs.85)">POINT</a> structure to convert.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-makepoints">MAKEPOINTS</a>



<a href="https://docs.microsoft.com/previous-versions/dd162805(v=vs.85)">POINT</a>



<a href="https://docs.microsoft.com/previous-versions/dd162808(v=vs.85)">POINTS</a>



<a href="https://docs.microsoft.com/windows/desktop/gdi/rectangle-macros">Rectangle Macros</a>



<a href="https://docs.microsoft.com/windows/desktop/gdi/rectangles">Rectangles Overview</a>
 

 

