---
UID: NS:winuser.tagHARDWAREINPUT
title: HARDWAREINPUT (winuser.h)
description: Contains information about a simulated message generated by an input device other than a keyboard or mouse.
old-location: inputdev\hardwareinput.htm
tech.root: inputdev
ms.assetid: VS|winui|~\winui\windowsuserinterface\userinput\keyboardinput\keyboardinputreference\keyboardinputstructures\hardwareinput.htm
ms.date: 12/05/2018
ms.keywords: '*LPHARDWAREINPUT, *PHARDWAREINPUT, HARDWAREINPUT, HARDWAREINPUT structure [Keyboard and Mouse Input], PHARDWAREINPUT, PHARDWAREINPUT structure pointer [Keyboard and Mouse Input], _win32_HARDWAREINPUT_str, _win32_hardwareinput_str_cpp, inputdev.hardwareinput, winui._win32_hardwareinput_str, winuser/HARDWAREINPUT, winuser/PHARDWAREINPUT'
f1_keywords:
- winuser/HARDWAREINPUT
dev_langs:
- c++
req.header: winuser.h
req.include-header: Windows.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Winuser.h
api_name:
- HARDWAREINPUT
targetos: Windows
req.typenames: HARDWAREINPUT, *PHARDWAREINPUT, *LPHARDWAREINPUT
req.redist: 
ms.custom: 19H1
---

# HARDWAREINPUT structure


## -description


Contains information about a simulated message generated by an input device other than a keyboard or mouse. 


## -struct-fields




### -field uMsg

Type: <b>DWORD</b>

The message generated by the input hardware. 


### -field wParamL

Type: <b>WORD</b>

The low-order word of the <i>lParam </i> parameter for <b>uMsg</b>. 


### -field wParamH

Type: <b>WORD</b>

The high-order word of the <i>lParam </i> parameter for <b>uMsg</b>. 


## -see-also




<b>Conceptual</b>



<a href="https://docs.microsoft.com/windows/desktop/api/winuser/ns-winuser-input">INPUT</a>



<a href="https://docs.microsoft.com/windows/desktop/inputdev/keyboard-input">Keyboard Input</a>



<b>Reference</b>



<a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-sendinput">SendInput</a>
 

 

