---
UID: NS:winuser.tagINPUT_MESSAGE_SOURCE
title: INPUT_MESSAGE_SOURCE (winuser.h)
description: Contains information about the source of the input message.
old-location: input_sourceid\input_message_source.htm
tech.root: Input_SourceId
ms.assetid: 75437c0a-925a-44d9-9254-43095b281c21
ms.date: 12/05/2018
ms.keywords: INPUT_MESSAGE_SOURCE, INPUT_MESSAGE_SOURCE structure, input_sourceid.input_message_source, inputsourceid.input_message_source, tagINPUT_MESSAGE_SOURCE, winuser/INPUT_MESSAGE_SOURCE
f1_keywords:
- winuser/INPUT_MESSAGE_SOURCE
dev_langs:
- c++
req.header: winuser.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 [desktop apps only]
req.target-min-winversvr: None supported
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- winuser.h
api_name:
- INPUT_MESSAGE_SOURCE
targetos: Windows
req.typenames: INPUT_MESSAGE_SOURCE
req.redist: 
ms.custom: 19H1
---

# INPUT_MESSAGE_SOURCE structure


## -description


Contains information about the source of the input message.


## -struct-fields




### -field deviceType

The device type (<a href="https://docs.microsoft.com/windows/desktop/api/winuser/ne-winuser-input_message_device_type">INPUT_MESSAGE_DEVICE_TYPE</a>) of the source of the input message.


### -field originId

The ID (<a href="https://docs.microsoft.com/windows/desktop/api/winuser/ne-winuser-input_message_origin_id">INPUT_MESSAGE_ORIGIN_ID</a>) of the source of the input message.


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/input_sourceid/input-source-identification-reference">Input Source Identification Reference</a>
 

 

