---
UID: NE:wlanapi._WLAN_INTERFACE_TYPE
title: WLAN_INTERFACE_TYPE (wlanapi.h)
description: Specifies the wireless interface type.
old-location: nwifi\wlan_interface_type.htm
tech.root: NativeWiFi
ms.assetid: c7a3aa6c-2f66-4d45-a975-f6da433e368f
ms.date: 12/05/2018
ms.keywords: '*PWLAN_INTERFACE_TYPE, PWLAN_INTERFACE_TYPE, PWLAN_INTERFACE_TYPE enumeration pointer [NativeWIFI], WLAN_INTERFACE_TYPE, WLAN_INTERFACE_TYPE enumeration [NativeWIFI], nwifi.wlan_interface_type, wlan_interface_type_emulated_802_11, wlan_interface_type_invalid, wlan_interface_type_native_802_11, wlanapi/PWLAN_INTERFACE_TYPE, wlanapi/WLAN_INTERFACE_TYPE, wlanapi/wlan_interface_type_emulated_802_11, wlanapi/wlan_interface_type_invalid, wlanapi/wlan_interface_type_native_802_11'
f1_keywords:
- wlanapi/WLAN_INTERFACE_TYPE
dev_langs:
- c++
req.header: wlanapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista, Windows XP with SP3 [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- wlanapi.h
api_name:
- WLAN_INTERFACE_TYPE
targetos: Windows
req.typenames: WLAN_INTERFACE_TYPE, *PWLAN_INTERFACE_TYPE
req.redist: Wireless LAN API for Windows XP with SP2
ms.custom: 19H1
---

# WLAN_INTERFACE_TYPE enumeration


## -description


The <b>WLAN_INTERFACE_TYPE</b> enumeration specifies the wireless interface type.


## -enum-fields




### -field wlan_interface_type_emulated_802_11

Specifies an emulated 802.11 interface. 


### -field wlan_interface_type_native_802_11

Specifies a native 802.11 interface. 


### -field wlan_interface_type_invalid

The interface specified is invalid.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/wlanapi/ns-wlanapi-wlan_interface_capability">WLAN_INTERFACE_CAPABILITY</a>
 

 

