---
UID: NF:wlanapi.WlanRegisterNotification
title: WlanRegisterNotification function (wlanapi.h)
description: Is used to register and unregister notifications on all wireless interfaces.
old-location: nwifi\wlanregisternotification.htm
tech.root: NativeWiFi
ms.assetid: e24810da-ed3b-41c4-b7b1-290b01e26cd5
ms.date: 12/05/2018
ms.keywords: WLAN_NOTIFICATION_SOURCE_ACM, WLAN_NOTIFICATION_SOURCE_ALL, WLAN_NOTIFICATION_SOURCE_HNWK, WLAN_NOTIFICATION_SOURCE_IHV, WLAN_NOTIFICATION_SOURCE_MSM, WLAN_NOTIFICATION_SOURCE_NONE, WLAN_NOTIFICATION_SOURCE_ONEX, WLAN_NOTIFICATION_SOURCE_SECURITY, WlanRegisterNotification, WlanRegisterNotification function [NativeWIFI], nwifi.wlanregisternotification, wlanapi/WlanRegisterNotification
f1_keywords:
- wlanapi/WlanRegisterNotification
dev_langs:
- c++
req.header: wlanapi.h
req.include-header: Wlanapi.h
req.target-type: Windows
req.target-min-winverclnt: Windows Vista, Windows XP with SP3 [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Wlanapi.lib
req.dll: Wlanapi.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- wlanapi.dll
api_name:
- WlanRegisterNotification
targetos: Windows
req.typenames: 
req.redist: Wireless LAN API for Windows XP with SP2
ms.custom: 19H1
---

# WlanRegisterNotification function


## -description


The <b>WlanRegisterNotification</b> function is used to register and unregister notifications on all wireless interfaces.  


## -parameters




### -param hClientHandle [in]

The client's session handle, obtained by a previous call to the <a href="https://docs.microsoft.com/windows/desktop/api/wlanapi/nf-wlanapi-wlanopenhandle">WlanOpenHandle</a> function.


### -param dwNotifSource [in]

The notification sources to be registered. These flags may be combined. When this parameter is set to <b>WLAN_NOTIFICATION_SOURCE_NONE</b>, <b>WlanRegisterNotification</b> unregisters notifications on all wireless interfaces. 

The possible values for this parameter are defined in the <i>Wlanapi.h</i> and <i>L2cmn.h</i> header files.


The following table shows possible values.



<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="WLAN_NOTIFICATION_SOURCE_NONE"></a><a id="wlan_notification_source_none"></a><dl>
<dt><b>WLAN_NOTIFICATION_SOURCE_NONE</b></dt>
</dl>
</td>
<td width="60%">
Unregisters notifications.

</td>
</tr>
<tr>
<td width="40%"><a id="WLAN_NOTIFICATION_SOURCE_ALL"></a><a id="wlan_notification_source_all"></a><dl>
<dt><b>WLAN_NOTIFICATION_SOURCE_ALL</b></dt>
</dl>
</td>
<td width="60%">
Registers for all notifications available on the version of the operating system, including those generated by the 802.1X module. 

For Windows XP with SP3 and Wireless LAN API for Windows XP with SP2, setting <i>dwNotifSource</i> to <b>WLAN_NOTIFICATION_SOURCE_ALL</b> is functionally equivalent to setting <i>dwNotifSource</i> to <b>WLAN_NOTIFICATION_SOURCE_ACM</b>.

</td>
</tr>
<tr>
<td width="40%"><a id="WLAN_NOTIFICATION_SOURCE_ACM"></a><a id="wlan_notification_source_acm"></a><dl>
<dt><b>WLAN_NOTIFICATION_SOURCE_ACM</b></dt>
</dl>
</td>
<td width="60%">
Registers for notifications generated by the auto configuration module.

<b>Windows XP with SP3 and Wireless LAN API for Windows XP with SP2:  </b>Only the wlan_notification_acm_connection_complete and wlan_notification_acm_disconnected notifications are available.

</td>
</tr>
<tr>
<td width="40%"><a id="WLAN_NOTIFICATION_SOURCE_HNWK"></a><a id="wlan_notification_source_hnwk"></a><dl>
<dt><b>WLAN_NOTIFICATION_SOURCE_HNWK</b></dt>
</dl>
</td>
<td width="60%">
Registers for notifications generated by the wireless Hosted Network. This notification source is available on Windows 7 and  on Windows Server 2008 R2 with the Wireless LAN Service installed.

</td>
</tr>
<tr>
<td width="40%"><a id="WLAN_NOTIFICATION_SOURCE_ONEX"></a><a id="wlan_notification_source_onex"></a><dl>
<dt><b>WLAN_NOTIFICATION_SOURCE_ONEX</b></dt>
</dl>
</td>
<td width="60%">
Registers for notifications generated by 802.1X.

</td>
</tr>
<tr>
<td width="40%"><a id="WLAN_NOTIFICATION_SOURCE_MSM"></a><a id="wlan_notification_source_msm"></a><dl>
<dt><b>WLAN_NOTIFICATION_SOURCE_MSM</b></dt>
</dl>
</td>
<td width="60%">
Registers for notifications generated by MSM.

<b>Windows XP with SP3 and Wireless LAN API for Windows XP with SP2:  </b>This value is not supported.

</td>
</tr>
<tr>
<td width="40%"><a id="WLAN_NOTIFICATION_SOURCE_SECURITY"></a><a id="wlan_notification_source_security"></a><dl>
<dt><b>WLAN_NOTIFICATION_SOURCE_SECURITY</b></dt>
</dl>
</td>
<td width="60%">
Registers for notifications generated by the security module.

No notifications are currently defined for <b>WLAN_NOTIFICATION_SOURCE_SECURITY</b>.

<b>Windows XP with SP3 and Wireless LAN API for Windows XP with SP2:  </b>This value is not supported.

</td>
</tr>

<tr>
<td width="40%"><a id="WLAN_NOTIFICATION_SOURCE_IHV"></a><a id="wlan_notification_source_ihv"></a><dl>
<dt><b>WLAN_NOTIFICATION_SOURCE_IHV</b></dt>
</dl>
</td>
<td width="60%">
Registers for notifications generated by independent hardware vendors (IHV).
<b>Windows XP with SP3 and Wireless LAN API for Windows XP with SP2:  </b>This value is not supported.
</td>
</tr>

<tr>
<td width="40%"><a id="WLAN_NOTIFICATION_SOURCE_DEVICE_SERVICE"></a><a id="wlan_notification_source_ihv"></a><dl>
<dt><b>WLAN_NOTIFICATION_SOURCE_IHV</b></dt>
</dl>
</td>
<td width="60%">Registers for notifications generated by device services.</td>
</tr>

</table>

<b>Windows XP with SP3 and Wireless LAN API for Windows XP with SP2:  </b>This parameter must be set to WLAN_NOTIFICATION_SOURCE_NONE, WLAN_NOTIFICATION_SOURCE_ALL, or WLAN_NOTIFICATION_SOURCE_ACM.


### -param bIgnoreDuplicate [in]

Specifies whether duplicate notifications will be ignored.  If set to <b>TRUE</b>, a notification will not be sent to the client if it is identical to the previous one.

<b>Windows XP with SP3 and Wireless LAN API for Windows XP with SP2:  </b>This parameter is ignored.


### -param funcCallback [in, optional]

A <a href="https://docs.microsoft.com/windows/desktop/api/wlanapi/nc-wlanapi-wlan_notification_callback">WLAN_NOTIFICATION_CALLBACK</a>  type that defines the type of notification callback function.

This parameter can be <b>NULL</b> if the <i>dwNotifSource</i> parameter is set to <b>WLAN_NOTIFICATION_SOURCE_NONE</b> to unregister notifications on all wireless interfaces,


### -param pCallbackContext [in, optional]

A pointer to the client context that will be passed to the callback function with the notification.


### -param pReserved [in]

Reserved for future use.  Must be set to <b>NULL</b>.


### -param pdwPrevNotifSource [out, optional]

A pointer to the previously registered notification sources.


## -returns



If the function succeeds, the return value is ERROR_SUCCESS.

If the function fails, the return value may be one of the following return codes.

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_INVALID_PARAMETER</b></dt>
</dl>
</td>
<td width="60%">
A  parameter is incorrect. This error is returned if <i>hClientHandle</i> is <b>NULL</b> or not valid or if <i>pReserved</i> is not <b>NULL</b>.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_INVALID_HANDLE</b></dt>
</dl>
</td>
<td width="60%">
The handle <i>hClientHandle</i>  was not found in the handle table.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_NOT_ENOUGH_MEMORY</b></dt>
</dl>
</td>
<td width="60%">
Failed to allocate memory for the query results.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>RPC_STATUS</b></dt>
</dl>
</td>
<td width="60%">
Various error codes.

</td>
</tr>
</table>
 




## -remarks



The <b>WlanRegisterNotification</b> is used by an application to register and unregister notifications on all wireless interfaces. When registering for notifications, an application must provide a callback function pointed to by the <i>funcCallback</i> parameter. The prototype for this callback function is the <a href="https://docs.microsoft.com/windows/desktop/api/wlanapi/nc-wlanapi-wlan_notification_callback">WLAN_NOTIFICATION_CALLBACK</a>. This callback function will receive notifications that have been registered for in the <i>dwNotifSource</i> parameter passed to the <b>WlanRegisterNotification</b> function. The callback function is called with a pointer to a  <a href="https://docs.microsoft.com/previous-versions/windows/desktop/legacy/ms706902(v=vs.85)">WLAN_NOTIFICATION_DATA</a> structure as the first parameter that contains detailed information on the notification. The callback function also receives a second parameter that contains a pointer to the client context passed in the <i>pCallbackContext</i> parameter to the <b>WlanRegisterNotification</b> function.

The <b>WlanRegisterNotification</b> function will return an error if <i>dwNotifSource</i> is a value other than <b>WLAN_NOTIFICATION_SOURCE_NONE</b> and the client fails to provide a callback function.

Once registered, the callback function will be called whenever a notification is available until the client unregisters or closes the handle.

Any registration to receive notifications caused by this function would be automatically undone if the calling application closes its calling handle (by calling <a href="https://docs.microsoft.com/windows/desktop/api/wlanapi/nf-wlanapi-wlanclosehandle">WlanCloseHandle</a> with the <i>hClientHandle</i> parameter) or if the process ends.


  Do not call <b>WlanRegisterNotification</b> from a callback function. If the client is in the middle of a notification callback when <b>WlanRegisterNotification</b> is called with <i>dwNotifSource</i> set to  <b>WLAN_NOTIFICATION_SOURCE_NONE</b> (that is, when the client is unregistering from notifications), <b>WlanRegisterNotification</b>  will wait for the callback to finish before returning a value. Calling this function inside a callback function will result in the call never completing. If both the callback function and the thread that unregisters from notifications try to acquire the same lock, a deadlock may occur. In addition, do not call <b>WlanRegisterNotification</b> from the <b>DllMain</b> function in an application DLL. This could also cause a deadlock. 

An application can time out and query the current interface state instead of waiting for a notification.

<b>Windows XP with SP3 and Wireless LAN API for Windows XP with SP2:  </b>Notifications are handled by the Netman service. If the Netman service is disabled or unavailable, notifications will not be received. If a notification is not received within a reasonable period of time, an application should time out and query the current interface state.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/dot1x/ne-dot1x-onex_notification_type">ONEX_NOTIFICATION_TYPE</a>



<a href="https://docs.microsoft.com/windows/win32/api/wlanapi/ne-wlanapi-wlan_hosted_network_notification_code">WLAN_HOSTED_NETWORK_NOTIFICATION_CODE</a>



<a href="https://docs.microsoft.com/windows/win32/api/wlanapi/ne-wlanapi-wlan_notification_acm~r1">WLAN_NOTIFICATION_ACM</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wlanapi/nc-wlanapi-wlan_notification_callback">WLAN_NOTIFICATION_CALLBACK</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/legacy/ms706902(v=vs.85)">WLAN_NOTIFICATION_DATA</a>



<a href="https://docs.microsoft.com/windows/win32/api/wlanapi/ne-wlanapi-wlan_notification_msm~r1">WLAN_NOTIFICATION_MSM</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wlanapi/nf-wlanapi-wlanclosehandle">WlanCloseHandle</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wlanapi/nf-wlanapi-wlanregistervirtualstationnotification">WlanRegisterVirtualStationNotification</a>
 

 

