---
UID: NE:wmcontainer.ASF_STATUSFLAGS
title: ASF_STATUSFLAGS (wmcontainer.h)
description: Defines status conditions for the IMFASFSplitter::GetNextSample method.
old-location: mf\asf_statusflags.htm
tech.root: medfound
ms.assetid: c8f1944a-2b61-4c6e-8c87-37c2985fbdca
ms.date: 12/05/2018
ms.keywords: ASF_STATUSFLAGS, ASF_STATUSFLAGS enumeration [Media Foundation], ASF_STATUSFLAGS_INCOMPLETE, ASF_STATUSFLAGS_NONFATAL_ERROR, c8f1944a-2b61-4c6e-8c87-37c2985fbdca, mf.asf_statusflags, wmcontainer/ASF_STATUSFLAGS, wmcontainer/ASF_STATUSFLAGS_INCOMPLETE, wmcontainer/ASF_STATUSFLAGS_NONFATAL_ERROR
f1_keywords:
- wmcontainer/ASF_STATUSFLAGS
dev_langs:
- c++
req.header: wmcontainer.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- wmcontainer.h
api_name:
- ASF_STATUSFLAGS
targetos: Windows
req.typenames: ASF_STATUSFLAGS
req.redist: 
ms.custom: 19H1
---

# ASF_STATUSFLAGS enumeration


## -description



Defines status conditions for the <a href="https://docs.microsoft.com/windows/desktop/api/wmcontainer/nf-wmcontainer-imfasfsplitter-getnextsample">IMFASFSplitter::GetNextSample</a> method.




## -enum-fields




### -field ASF_STATUSFLAGS_INCOMPLETE

The operation is incomplete.


### -field ASF_STATUSFLAGS_NONFATAL_ERROR

 One or more non-critical errors
        occurred while parsing the ASF data.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/medfound/media-foundation-enumerations">Media Foundation Enumerations</a>
 

 

