---
UID: NF:wmiutils.IWbemQuery.GetAnalysis
title: IWbemQuery::GetAnalysis (wmiutils.h)
description: Gets the results of a successful query parse.
old-location: wmi\iwbemquery_getanalysis.htm
tech.root: WmiSdk
ms.assetid: 06cd2593-58f5-46b9-9100-debad0280d90
ms.date: 12/05/2018
ms.keywords: GetAnalysis, GetAnalysis method [Windows Management Instrumentation], GetAnalysis method [Windows Management Instrumentation],IWbemQuery interface, IWbemQuery interface [Windows Management Instrumentation],GetAnalysis method, IWbemQuery.GetAnalysis, IWbemQuery::GetAnalysis, WMIQ_ANALYSIS_ASSOC_QUERY, WMIQ_ANALYSIS_PROP_ANALYSIS_MATRIX, WMIQ_ANALYSIS_QUERY_TEXT, WMIQ_ANALYSIS_RPN_SEQUENCE, _hmm_iwbemquery_getanalysis, wmi.iwbemquery_getanalysis, wmiutils/IWbemQuery::GetAnalysis
f1_keywords:
- wmiutils/IWbemQuery.GetAnalysis
dev_langs:
- c++
req.header: wmiutils.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista
req.target-min-winversvr: Windows Server 2008
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Wbemuuid.lib
req.dll: Wmiutils.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Wmiutils.dll
api_name:
- IWbemQuery.GetAnalysis
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IWbemQuery::GetAnalysis


## -description


The 
<b>IWbemQuery::GetAnalysis</b> method gets the results of a successful query parse.


## -parameters




### -param uAnalysisType [in]

Type of analysis to get.



#### WMIQ_ANALYSIS_RPN_SEQUENCE (1)

Used if the query has a SELECT clause. When this type of analysis is used,  <i>pAnalysis</i> points to an <a href="https://docs.microsoft.com/windows/win32/api/wmiutils/ns-wmiutils-swbemrpnencodedquery">SWbemRpnEncodedQuery</a> structure.



#### WMIQ_ANALYSIS_ASSOC_QUERY (2)

Used to return information about association type queries. When this type of analysis is used,  <i>pAnalysis</i> points to an <a href="https://docs.microsoft.com/windows/win32/api/wmiutils/ns-wmiutils-swbemassocqueryinf">SWbemAssocQueryInf</a> structure.



#### WMIQ_ANALYSIS_PROP_ANALYSIS_MATRIX (3)

Unused.  Reserved for future use.



#### WMIQ_ANALYSIS_QUERY_TEXT (4)

Used to return a text string that has the original query text. If this type of analysis is used,  <i>pAnalysis</i> points to a text string that contains the original query text.

You can use this parameter if  a parser object is passed to another method.


### -param uFlags [in]

Reserved for future use.


### -param pAnalysis [out]

Pointer to the analysis generated by a call to 
<b>IWbemQuery::GetAnalysis</b>. It is important to free up this memory by calling 
<a href="https://docs.microsoft.com/windows/desktop/api/wmiutils/nf-wmiutils-iwbemquery-freememory">IWbemQuery::FreeMemory</a>.


## -returns



This method returns an <b>HRESULT</b> that indicates the status of a method call.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/wmiutils/nn-wmiutils-iwbemquery">IWbemQuery</a>



<a href="https://docs.microsoft.com/windows/win32/api/wmiutils/ns-wmiutils-swbemassocqueryinf">SWbemAssocQueryInf</a>



<a href="https://docs.microsoft.com/windows/win32/api/wmiutils/ns-wmiutils-swbemrpnencodedquery">SWbemRpnEncodedQuery</a>
 

 

