---
UID: NF:wmp.IWMPControls2.step
title: IWMPControls2::step (wmp.h)
description: The step method causes the current video media item to freeze playback on the next frame or the previous frame.
old-location: wmp\iwmpcontrols2_step.htm
tech.root: WMP
ms.assetid: d54a4bb7-855f-4807-89b5-176b7fac2edd
ms.date: 12/05/2018
ms.keywords: IWMPControls2 interface [Windows Media Player],step method, IWMPControls2.step, IWMPControls2::step, IWMPControls2step, step, step method [Windows Media Player], step method [Windows Media Player],IWMPControls2 interface, wmp.iwmpcontrols2_step, wmp/IWMPControls2::step
f1_keywords:
- wmp/IWMPControls2.step
dev_langs:
- c++
req.header: wmp.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Media Player 9 Series or later.
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: Wmp.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- wmp.dll
api_name:
- IWMPControls2.step
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IWMPControls2::step


## -description



The <b>step</b> method causes the current video media item to freeze playback on the next frame or the previous frame.




## -parameters




### -param lStep [in]

<b>long</b> indicating how many frames to step before freezing. Must be set to 1 or -1.


## -returns



The method returns an <b>HRESULT</b>. Possible values include, but are not limited to, those in the following table.

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>S_OK</b></dt>
</dl>
</td>
<td width="60%">
The method succeeded.

</td>
</tr>
</table>
 




## -remarks



This method currently only supports the parameters 1 or -1, so you can only step one frame at a time.

<b>Windows Media Player 10 Mobile: </b>This method always returns E_INVALIDARG.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/wmp/nn-wmp-iwmpcontrols2">IWMPControls2 Interface</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wmp/nn-wmp-iwmpdvd">IWMPDVD Interface</a>
 

 

