---
UID: NF:wmpservices.IWMPPluginEnable.SetEnable
title: IWMPPluginEnable::SetEnable (wmpservices.h)
description: The IWMPPluginEnable::SetEnable method retrieves a value indicating whether user has enabled the plug-in.
old-location: wmp\iwmppluginenable_setenable.htm
tech.root: WMP
ms.assetid: a0b8e79b-e9bd-40e5-ab58-11469406110a
ms.date: 12/05/2018
ms.keywords: IWMPPluginEnable interface [Windows Media Player],SetEnable method, IWMPPluginEnable.SetEnable, IWMPPluginEnable::SetEnable, IWMPPluginEnableSetEnableDSP, SetEnable, SetEnable method [Windows Media Player], SetEnable method [Windows Media Player],IWMPPluginEnable interface, wmp.iwmppluginenable_setenable, wmpservices/IWMPPluginEnable::SetEnable
f1_keywords:
- wmpservices/IWMPPluginEnable.SetEnable
dev_langs:
- c++
req.header: wmpservices.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Media Player 9 Series or later.
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- wmpservices.h
api_name:
- IWMPPluginEnable.SetEnable
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IWMPPluginEnable::SetEnable


## -description



The <b>IWMPPluginEnable::SetEnable</b> method retrieves a value indicating whether user has enabled the plug-in.




## -parameters




### -param fEnable [in]

A variable that receives a value indicating whether the user has enabled the plug-in.


## -returns



The method returns an <b>HRESULT</b>.




## -remarks



The value of <i>fEnable</i> depends upon whether the user has enabled the plug-in on the <b>Plug-ins</b> tab of the Options dialog box in Windows Media Player.

DSP plug-ins are removed from the signal path when the user chooses to disable them. When disabled, a plug-in should still include code to copy data from the input buffer to the output buffer, performing only format conversion processing, if applicable. The sample code generated by the Windows Media Player plug-in wizard includes code to copy the buffers.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/wmpservices/nn-wmpservices-iwmppluginenable">IWMPPluginEnable Interface</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wmpservices/nf-wmpservices-iwmppluginenable-getenable">IWMPPluginEnable::GetEnable</a>
 

 

