---
UID: NF:wmpservices.IWMPUserEventSink.NotifyUserEvent
title: IWMPUserEventSink::NotifyUserEvent (wmpservices.h)
description: The NotifyUserEvent method notifies an application of an event generated by a custom video presenter that the application provided to the Enhanced Video Renderer (EVR).
old-location: wmp\iwmpusereventsink_notifyuserevent.htm
tech.root: WMP
ms.assetid: f3a84ff8-2f96-43ab-a8a7-7c07d07927dc
ms.date: 12/05/2018
ms.keywords: IWMPUserEventSink interface [Windows Media Player],NotifyUserEvent method, IWMPUserEventSink.NotifyUserEvent, IWMPUserEventSink::NotifyUserEvent, IWMPUserEventSinkNotifyUserEvent, NotifyUserEvent, NotifyUserEvent method [Windows Media Player], NotifyUserEvent method [Windows Media Player],IWMPUserEventSink interface, wmp.iwmpusereventsink_notifyuserevent, wmpservices/IWMPUserEventSink::NotifyUserEvent
f1_keywords:
- wmpservices/IWMPUserEventSink.NotifyUserEvent
dev_langs:
- c++
req.header: wmpservices.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Media Player 11
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: Wmp.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- wmp.dll
api_name:
- IWMPUserEventSink.NotifyUserEvent
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IWMPUserEventSink::NotifyUserEvent


## -description



The <b>NotifyUserEvent</b> method notifies an application of an event generated by a custom video presenter that the application provided to the Enhanced Video Renderer (EVR).




## -parameters




### -param EventCode [in]

An event code that is meaningful only to the application and the custom video renderer. The event code must have a value greater than or equal to WMPUE_EC_USER, which is defined in wmpservices.h.


## -returns



The method returns an <b>HRESULT</b>. Possible values include, but are not limited to, those in the following table.

<table>
<tr>
<th>Value
                </th>
<th>Description
                </th>
</tr>
<tr>
<td>S_OK</td>
<td>The method succeeded.</td>
</tr>
</table>
 




## -remarks



An application that embeds the Windows Media Player control can provide a custom video renderer for the EVR by calling <a href="https://docs.microsoft.com/windows/desktop/api/wmprealestate/nf-wmprealestate-iwmpvideorenderconfig-put_presenteractivate">IWMPVideoRenderConfig::put_presenterActivate</a>. As the custom video renderer runs, it can notify the EVR of events by calling <b>IMediaEventSink::Notify</b>. If the event code supplied by the custom video renderer is greater than or equal to WMPUE_EC_USER, the EVR passes the event notification along to the application by calling <b>NotifyUserEvent</b>.

The definition of WMPUE_EC_USER depends on the definition of EC_USER, which is defined in evcode.h.

<b>Windows Media Player 10 Mobile: </b>This method is not supported.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/wmpservices/nn-wmpservices-iwmpusereventsink">IWMPUserEventSink Interface</a>
 

 

