---
UID: NE:wmsdkidl.WMT_STATUS
title: WMT_STATUS (wmsdkidl.h)
description: The WMT_STATUS enumeration type defines a range of file status information.
old-location: wmformat\wmt_status.htm
tech.root: wmformat
ms.assetid: ebf77e8a-65e8-4da9-bb21-a1e2bf427bbf
ms.date: 12/05/2018
ms.keywords: WMT_ACQUIRE_LICENSE, WMT_BACKUPRESTORE_BEGIN, WMT_BACKUPRESTORE_CONNECTING, WMT_BACKUPRESTORE_DISCONNECTING, WMT_BACKUPRESTORE_END, WMT_BUFFERING_START, WMT_BUFFERING_STOP, WMT_CLIENT_CONNECT, WMT_CLIENT_CONNECT_EX, WMT_CLIENT_DISCONNECT, WMT_CLIENT_DISCONNECT_EX, WMT_CLIENT_PROPERTIES, WMT_CLOSED, WMT_CONNECTING, WMT_CONTENT_ENABLER, WMT_END_OF_FILE, WMT_END_OF_SEGMENT, WMT_END_OF_STREAMING, WMT_EOF, WMT_ERROR, WMT_ERROR_WITHURL, WMT_INDEX_PROGRESS, WMT_INDIVIDUALIZE, WMT_INIT_PLAYLIST_BURN, WMT_LICENSEURL_SIGNATURE_STATE, WMT_LOCATING, WMT_MISSING_CODEC, WMT_NATIVE_OUTPUT_PROPS_CHANGED, WMT_NEEDS_INDIVIDUALIZATION, WMT_NEW_METADATA, WMT_NEW_SOURCEFLAGS, WMT_NO_RIGHTS, WMT_NO_RIGHTS_EX, WMT_OPENED, WMT_PREROLL_COMPLETE, WMT_PREROLL_READY, WMT_PROXIMITY_COMPLETED, WMT_PROXIMITY_RESULT, WMT_RECONNECT_END, WMT_RECONNECT_START, WMT_RESTRICTED_LICENSE, WMT_SAVEAS_START, WMT_SAVEAS_STOP, WMT_SET_FEC_SPAN, WMT_SOURCE_SWITCH, WMT_STARTED, WMT_STATUS, WMT_STATUS enumeration [windows Media Format], WMT_STOPPED, WMT_STRIDING, WMT_TIMER, WMT_TRANSCRYPTOR_CLOSED, WMT_TRANSCRYPTOR_INIT, WMT_TRANSCRYPTOR_READ, WMT_TRANSCRYPTOR_SEEKED, wmformat.wmt_status, wmsdkidl/WMT_ACQUIRE_LICENSE, wmsdkidl/WMT_BACKUPRESTORE_BEGIN, wmsdkidl/WMT_BACKUPRESTORE_CONNECTING, wmsdkidl/WMT_BACKUPRESTORE_DISCONNECTING, wmsdkidl/WMT_BACKUPRESTORE_END, wmsdkidl/WMT_BUFFERING_START, wmsdkidl/WMT_BUFFERING_STOP, wmsdkidl/WMT_CLIENT_CONNECT, wmsdkidl/WMT_CLIENT_CONNECT_EX, wmsdkidl/WMT_CLIENT_DISCONNECT, wmsdkidl/WMT_CLIENT_DISCONNECT_EX, wmsdkidl/WMT_CLIENT_PROPERTIES, wmsdkidl/WMT_CLOSED, wmsdkidl/WMT_CONNECTING, wmsdkidl/WMT_CONTENT_ENABLER, wmsdkidl/WMT_END_OF_FILE, wmsdkidl/WMT_END_OF_SEGMENT, wmsdkidl/WMT_END_OF_STREAMING, wmsdkidl/WMT_EOF, wmsdkidl/WMT_ERROR, wmsdkidl/WMT_ERROR_WITHURL, wmsdkidl/WMT_INDEX_PROGRESS, wmsdkidl/WMT_INDIVIDUALIZE, wmsdkidl/WMT_INIT_PLAYLIST_BURN, wmsdkidl/WMT_LICENSEURL_SIGNATURE_STATE, wmsdkidl/WMT_LOCATING, wmsdkidl/WMT_MISSING_CODEC, wmsdkidl/WMT_NATIVE_OUTPUT_PROPS_CHANGED, wmsdkidl/WMT_NEEDS_INDIVIDUALIZATION, wmsdkidl/WMT_NEW_METADATA, wmsdkidl/WMT_NEW_SOURCEFLAGS, wmsdkidl/WMT_NO_RIGHTS, wmsdkidl/WMT_NO_RIGHTS_EX, wmsdkidl/WMT_OPENED, wmsdkidl/WMT_PREROLL_COMPLETE, wmsdkidl/WMT_PREROLL_READY, wmsdkidl/WMT_PROXIMITY_COMPLETED, wmsdkidl/WMT_PROXIMITY_RESULT, wmsdkidl/WMT_RECONNECT_END, wmsdkidl/WMT_RECONNECT_START, wmsdkidl/WMT_RESTRICTED_LICENSE, wmsdkidl/WMT_SAVEAS_START, wmsdkidl/WMT_SAVEAS_STOP, wmsdkidl/WMT_SET_FEC_SPAN, wmsdkidl/WMT_SOURCE_SWITCH, wmsdkidl/WMT_STARTED, wmsdkidl/WMT_STATUS, wmsdkidl/WMT_STOPPED, wmsdkidl/WMT_STRIDING, wmsdkidl/WMT_TIMER, wmsdkidl/WMT_TRANSCRYPTOR_CLOSED, wmsdkidl/WMT_TRANSCRYPTOR_INIT, wmsdkidl/WMT_TRANSCRYPTOR_READ, wmsdkidl/WMT_TRANSCRYPTOR_SEEKED
f1_keywords:
- wmsdkidl/WMT_STATUS
dev_langs:
- c++
req.header: wmsdkidl.h
req.include-header: Wmsdk.h
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only],Windows Media Format 7 SDK, or later versions of the SDK
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Wmsdkidl.h
api_name:
- WMT_STATUS
targetos: Windows
req.typenames: WMT_STATUS
req.redist: 
ms.custom: 19H1
---

# WMT_STATUS enumeration


## -description



The <b>WMT_STATUS</b> enumeration type defines a range of file status information. Members of <b>WMT_STATUS</b> are passed to the common callback function, <a href="https://docs.microsoft.com/windows/desktop/api/wmsdkidl/nf-wmsdkidl-iwmstatuscallback-onstatus">IWMStatusCallback::OnStatus</a>, so that the application can respond to the changing status of the objects being used.




## -enum-fields




### -field WMT_ERROR

An error occurred.


### -field WMT_OPENED

A file was opened.


### -field WMT_BUFFERING_START

The reader object is beginning to buffer content.


### -field WMT_BUFFERING_STOP

The reader object has finished buffering content.


### -field WMT_EOF

The end of the file has been reached. Both this member and the next one, <b>WMT_END_OF_FILE</b>, have the value 4.


### -field WMT_END_OF_FILE

The end of the file has been reached. Both this member and the previous one, <b>WMT_EOF</b>, have the value 4.


### -field WMT_END_OF_SEGMENT

The end of a segment has been encountered.


### -field WMT_END_OF_STREAMING

The end of a server-side playlist has been reached.


### -field WMT_LOCATING

The reader object is locating requested data.


### -field WMT_CONNECTING

A reporting object is connecting to server.


### -field WMT_NO_RIGHTS

There is no <a href="https://docs.microsoft.com/windows/desktop/wmformat/wmformat-glossary">license</a> and the content is protected by version 1 digital rights management.


### -field WMT_MISSING_CODEC

The file loaded in the reader object contains compressed data for which no codec could be found. The <i>pValue</i> parameter in <b>OnStatus</b> contains a GUID. The first DWORD of this GUID contains the FOURCC or the format tag of the missing codec. The remaining bytes of the GUID can be ignored.

The <i>hr</i> parameter in <b>OnStatus</b> may equal S_OK, although a missing codec would normally be considered an error. Also, this event may be followed by WMT_STARTED with <i>hr</i> equal to S_OK, even if codecs are missing for every stream in the file. In that case, however, the application will not receive any decoded samples, and should stop the reader object.


### -field WMT_STARTED

A reporting object has begun operations.


### -field WMT_STOPPED

A reporting object has ceased operations.


### -field WMT_CLOSED

A file was closed.


### -field WMT_STRIDING

The reader object is playing content at above normal speed, or in reverse.


### -field WMT_TIMER

Timer event.


### -field WMT_INDEX_PROGRESS

Progress update from the indexer object.


### -field WMT_SAVEAS_START

The reader object has begun saving a file from a server.


### -field WMT_SAVEAS_STOP

The reader has stopped saving a file from a server.


### -field WMT_NEW_SOURCEFLAGS

The current file's header object contains certain attributes that are different from those of the previous file. This event is sent when playing a server-side playlist. Use the <a href="https://docs.microsoft.com/windows/desktop/api/wmsdkidl/nn-wmsdkidl-iwmheaderinfo">IWMHeaderInfo</a> interface to query for any of the following attributes in a new file: <a href="https://docs.microsoft.com/windows/desktop/wmformat/stridable">Stridable</a>, <a href="https://docs.microsoft.com/windows/desktop/wmformat/broadcast">Broadcast</a>, <a href="https://docs.microsoft.com/windows/desktop/wmformat/seekable">Seekable</a>, and <a href="https://docs.microsoft.com/windows/desktop/wmformat/hasimage">HasImage</a>.


### -field WMT_NEW_METADATA

The current file's header object contains metadata attributes that are different from those of the previous file. This event is sent when playing a server-side playlist. Use the <a href="https://docs.microsoft.com/windows/desktop/api/wmsdkidl/nn-wmsdkidl-iwmheaderinfo">IWMHeaderInfo</a> interface to query for any metadata attribute you are interested in.


### -field WMT_BACKUPRESTORE_BEGIN

A <a href="https://docs.microsoft.com/windows/desktop/wmformat/wmformat-glossary">license</a> backup or restore has started.


### -field WMT_SOURCE_SWITCH

The next source in the playlist was opened.


### -field WMT_ACQUIRE_LICENSE

The <a href="https://docs.microsoft.com/windows/desktop/wmformat/wmformat-glossary">license acquisition</a> process has completed. The <i>pValue</i> parameter in <b>OnStatus</b> contains a <a href="https://docs.microsoft.com/windows/desktop/wmformat/wm-get-license-data">WM_GET_LICENSE_DATA</a> structure. The <b>hr</b> member of this structure indicates whether the license was successfully acquired.


### -field WMT_INDIVIDUALIZE

<a href="https://docs.microsoft.com/windows/desktop/wmformat/wmformat-glossary">Individualization</a> status message.


### -field WMT_NEEDS_INDIVIDUALIZATION

The file loaded in the reader object cannot be played without a security update.


### -field WMT_NO_RIGHTS_EX

There is no <a href="https://docs.microsoft.com/windows/desktop/wmformat/wmformat-glossary">license</a> and the content is protected by version 7 digital rights management.


### -field WMT_BACKUPRESTORE_END

A <a href="https://docs.microsoft.com/windows/desktop/wmformat/wmformat-glossary">license</a> backup or restore has finished.


### -field WMT_BACKUPRESTORE_CONNECTING

The backup restorer object is connecting to a server.


### -field WMT_BACKUPRESTORE_DISCONNECTING

The backup restorer object is disconnecting from a server.


### -field WMT_ERROR_WITHURL

Error relating to the URL.


### -field WMT_RESTRICTED_LICENSE

The backup restorer object cannot back up one or more <a href="https://docs.microsoft.com/windows/desktop/wmformat/wmformat-glossary">licenses</a> because the right has been disallowed by the content owner.


### -field WMT_CLIENT_CONNECT

Sent when a client (a playing application or server) connects to a writer network sink object. The <i>pValue</i> parameter of the <a href="https://docs.microsoft.com/windows/desktop/api/wmsdkidl/nf-wmsdkidl-iwmstatuscallback-onstatus">IWMStatusCallback::OnStatus</a> callback is set to a <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/wmsdkidl/ns-wmsdkidl-wm_client_properties">WM_CLIENT_PROPERTIES</a> structure. New applications should wait for <b>WMT_CLIENT_CONNECT_EX</b> instead.


### -field WMT_CLIENT_DISCONNECT

Sent when a client (a playing application or server) disconnects from a writer network sink object. The <i>pValue</i> parameter of the <a href="https://docs.microsoft.com/windows/desktop/api/wmsdkidl/nf-wmsdkidl-iwmstatuscallback-onstatus">IWMStatusCallback::OnStatus</a> callback is set to a <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/wmsdkidl/ns-wmsdkidl-wm_client_properties">WM_CLIENT_PROPERTIES</a> structure. The values in this structure are identical to those sent on connection. New applications should wait for <b>WMT_CLIENT_DISCONNECT_EX</b> instead.


### -field WMT_NATIVE_OUTPUT_PROPS_CHANGED

Change in output properties.


### -field WMT_RECONNECT_START

Start of automatic reconnection to a server.


### -field WMT_RECONNECT_END

End of automatic reconnection to a server.


### -field WMT_CLIENT_CONNECT_EX

Sent when a client (a playing application or server) connects to a writer network sink object. The <i>pValue</i> parameter of the <a href="https://docs.microsoft.com/windows/desktop/api/wmsdkidl/nf-wmsdkidl-iwmstatuscallback-onstatus">IWMStatusCallback::OnStatus</a> callback is set to a <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/wmsdkidl/ns-wmsdkidl-wm_client_propertiesex">WM_CLIENT_PROPERTIES_EX</a> structure.


### -field WMT_CLIENT_DISCONNECT_EX

Sent when a client (a playing application or server) disconnects from a writer network sink object. The <i>pValue</i> parameter of the <a href="https://docs.microsoft.com/windows/desktop/api/wmsdkidl/nf-wmsdkidl-iwmstatuscallback-onstatus">IWMStatusCallback::OnStatus</a> callback is set to a <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/wmsdkidl/ns-wmsdkidl-wm_client_propertiesex">WM_CLIENT_PROPERTIES_EX</a> structure. The client properties are identical to those sent on connection except for the <b>pwszDNSName</b> member, which may have changed.


### -field WMT_SET_FEC_SPAN

Change to the forward error correction span.


### -field WMT_PREROLL_READY

The reader is ready to begin buffering content.


### -field WMT_PREROLL_COMPLETE

The reader is finished buffering.


### -field WMT_CLIENT_PROPERTIES

Sent by a writer network sink when one or more properties of a connected client changes. The <i>pValue</i> parameter of the <a href="https://docs.microsoft.com/windows/desktop/api/wmsdkidl/nf-wmsdkidl-iwmstatuscallback-onstatus">IWMStatusCallback::OnStatus</a> callback is set to a <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/wmsdkidl/ns-wmsdkidl-wm_client_propertiesex">WM_CLIENT_PROPERTIES_EX</a> structure. This usually means that a DNS name is present for a client for which none was available at connection.


### -field WMT_LICENSEURL_SIGNATURE_STATE

Sent before a <b>WMT_NO_RIGHTS</b> or <b>WMT_NO_RIGHTS_EX</b> status message. The <i>pValue</i> parameter is set to one of the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/wmsdkidl/ne-wmsdkidl-wmt_drmla_trust">WMT_DRMLA_TRUST</a> constants indicating whether the <a href="https://docs.microsoft.com/windows/desktop/wmformat/wmformat-glossary">license acquisition</a> URL is completely trusted.


### -field WMT_INIT_PLAYLIST_BURN

Sent when the <a href="https://docs.microsoft.com/windows/desktop/api/wmsdkidl/nf-wmsdkidl-iwmreaderplaylistburn-initplaylistburn">IWMReaderPlaylistBurn::InitPlaylistBurn</a> method returns.


### -field WMT_TRANSCRYPTOR_INIT

Sent when the DRM transcryptor object is initialized with a file.


### -field WMT_TRANSCRYPTOR_SEEKED

Sent when the DRM transcryptor object seeks to a point in a file.


### -field WMT_TRANSCRYPTOR_READ

Sent when the DRM transcryptor object delivers Windows Media DRM 10 for Network Devices data from a DRM-protected file.


### -field WMT_TRANSCRYPTOR_CLOSED

Sent when the DRM transcryptor object is closed. After receiving this message, you can release the interface.


### -field WMT_PROXIMITY_RESULT

Sent when the proximity detection protocol has finished.


### -field WMT_PROXIMITY_COMPLETED

Sent when proximity detection thread has stopped running. The application must not release the <a href="https://docs.microsoft.com/windows/desktop/api/wmsdkidl/nn-wmsdkidl-iwmproximitydetection">IWMProximityDetection</a> interface until this message is received. Once launched, the thread runs for two minutes; there is no way to terminate the thread before two minutes have elapsed.



### -field WMT_CONTENT_ENABLER

Sent when a content enabler is required.


## -remarks



For more information on how this enumeration type is used, see the Remarks section for the <a href="https://docs.microsoft.com/windows/desktop/api/wmsdkidl/nf-wmsdkidl-iwmstatuscallback-onstatus">IWMStatusCallback::OnStatus</a> method.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/wmformat/enumeration-types">Enumeration Types</a>
 

 

