---
UID: NE:wmsdkidl.tagWMT_WATERMARK_ENTRY_TYPE
title: WMT_WATERMARK_ENTRY_TYPE (wmsdkidl.h)
description: The WMT_WATERMARK_ENTRY_TYPE enumeration type identifies the types of watermarking systems. Each watermarking system is a DirectX media object (DMO) that embeds some sort of digital watermark in digital media content.
old-location: wmformat\wmt_watermark_entry_type.htm
tech.root: wmformat
ms.assetid: 213fcf75-bc15-43a0-aafd-f9cd3c51de93
ms.date: 12/05/2018
ms.keywords: WMT_WATERMARK_ENTRY_TYPE, WMT_WATERMARK_ENTRY_TYPE enumeration [windows Media Format], WMT_WMETYPE_AUDIO, WMT_WMETYPE_VIDEO, wmformat.wmt_watermark_entry_type, wmsdkidl/WMT_WATERMARK_ENTRY_TYPE, wmsdkidl/WMT_WMETYPE_AUDIO, wmsdkidl/WMT_WMETYPE_VIDEO
f1_keywords:
- wmsdkidl/WMT_WATERMARK_ENTRY_TYPE
dev_langs:
- c++
req.header: wmsdkidl.h
req.include-header: Wmsdk.h
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only],Windows Media Format 9 Series SDK, or later versions of the SDK
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Wmsdkidl.h
api_name:
- WMT_WATERMARK_ENTRY_TYPE
targetos: Windows
req.typenames: WMT_WATERMARK_ENTRY_TYPE
req.redist: 
ms.custom: 19H1
---

# WMT_WATERMARK_ENTRY_TYPE enumeration


## -description



The <b>WMT_WATERMARK_ENTRY_TYPE</b> enumeration type identifies the types of watermarking systems. Each watermarking system is a DirectX media object (DMO) that embeds some sort of digital watermark in digital media content.




## -enum-fields




### -field WMT_WMETYPE_AUDIO

Identifies a watermarking DMO for audio.


### -field WMT_WMETYPE_VIDEO

Identifies a watermarking DMO for video.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/wmformat/enumeration-types">Enumeration Types</a>



<a href="https://docs.microsoft.com/windows/desktop/wmformat/watermarking-support">Watermarking Support</a>
 

 

