---
UID: NF:wmsdkidl.IWMLicenseRevocationAgent.GetLRBChallenge
title: IWMLicenseRevocationAgent::GetLRBChallenge (wmsdkidl.h)
description: The GetLRBChallenge method generates a response to a license revocation challenge message. Your application must send the response to the license server.
old-location: wmformat\iwmlicenserevocationagent_getlrbchallenge.htm
tech.root: wmformat
ms.assetid: 9006f6c5-f9e7-4d00-a7c2-bbdfcfdd85e7
ms.date: 12/05/2018
ms.keywords: GetLRBChallenge, GetLRBChallenge method [windows Media Format], GetLRBChallenge method [windows Media Format],IWMLicenseRevocationAgent interface, IWMLicenseRevocationAgent interface [windows Media Format],GetLRBChallenge method, IWMLicenseRevocationAgent.GetLRBChallenge, IWMLicenseRevocationAgent::GetLRBChallenge, IWMLicenseRevocationAgentGetLRBChallenge, wmformat.iwmlicenserevocationagent_getlrbchallenge, wmsdkidl/IWMLicenseRevocationAgent::GetLRBChallenge
f1_keywords:
- wmsdkidl/IWMLicenseRevocationAgent.GetLRBChallenge
dev_langs:
- c++
req.header: wmsdkidl.h
req.include-header: Wmsdk.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps only],Windows Media Format 9.5 SDK
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Wmvcore.lib; WMStubDRM.lib (if you use DRM)
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Wmvcore.lib
- Wmvcore.dll
- WMStubDRM.lib
- WMStubDRM.dll
api_name:
- IWMLicenseRevocationAgent.GetLRBChallenge
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IWMLicenseRevocationAgent::GetLRBChallenge


## -description



The <b>GetLRBChallenge</b> method generates a response to a license revocation challenge message. Your application must send the response to the license server.




## -parameters




### -param pMachineID [in]

Address of the machine identifier in memory. The format of the machine identifier is determined by the service that issued the license.


### -param dwMachineIDLength [in]

Size of the machine identifier in bytes.


### -param pChallenge [in]

Address of the challenge message in memory. This message is generated by a component created by the license issuer.


### -param dwChallengeLength [in]

Size of the challenge message in bytes.


### -param pChallengeOutput [out]

Address of a buffer that receives the challenge response message.


### -param pdwChallengeOutputLength [out]

Address of a variable that receives the size of the challenge response message in bytes.


## -returns



The method returns an <b>HRESULT</b>. Possible values include, but are not limited to, those in the following table.

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>S_OK</b></dt>
</dl>
</td>
<td width="60%">
The method succeeded.

</td>
</tr>
</table>
 




## -remarks



The license server generates the challenge as the result of user interaction. This process is typically managed by a Web component. The challenge response generated by calling this method must be sent back to the license server.

After the challenge and response have been processed, the license server sends a signed license revocation blob, which includes instructions about the licenses to remove. You can perform the license revocation by calling the <a href="https://docs.microsoft.com/windows/desktop/api/wmsdkidl/nf-wmsdkidl-iwmlicenserevocationagent-processlrb">ProcessLRB</a> method.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/wmsdkidl/nn-wmsdkidl-iwmlicenserevocationagent">IWMLicenseRevocationAgent Interface</a>
 

 

