---
UID: NS:wmsdkidl._WMClientProperties
title: WM_CLIENT_PROPERTIES (wmsdkidl.h)
description: The WM_CLIENT_PROPERTIES structure records information about the client.
old-location: wmformat\wm_client_properties.htm
tech.root: wmformat
ms.assetid: 62a5bafd-cc49-4a60-be03-038920e5b073
ms.date: 12/05/2018
ms.keywords: WM_CLIENT_PROPERTIES, WM_CLIENT_PROPERTIES structure [windows Media Format], wmformat.wm_client_properties, wmsdkidl/WM_CLIENT_PROPERTIES
f1_keywords:
- wmsdkidl/WM_CLIENT_PROPERTIES
dev_langs:
- c++
req.header: wmsdkidl.h
req.include-header: Wmsdk.h
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only],Windows Media Format 9 Series SDK, or later versions of the SDK
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Wmsdkidl.h
api_name:
- WM_CLIENT_PROPERTIES
targetos: Windows
req.typenames: WM_CLIENT_PROPERTIES
req.redist: 
ms.custom: 19H1
---

# WM_CLIENT_PROPERTIES structure


## -description



The <b>WM_CLIENT_PROPERTIES </b>structure records information about the client.




## -struct-fields




### -field dwIPAddress

<b>DWORD</b> containing the IP address.


### -field dwPort

<b>DWORD</b> containing the port number.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/wmsdkidl/nf-wmsdkidl-iwmclientconnections-getclientproperties">IWMClientConnections::GetClientProperties</a>



<a href="https://docs.microsoft.com/windows/desktop/wmformat/structures">Structures</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wmsdkidl/ne-wmsdkidl-wmt_net_protocol">WMT_NET_PROTOCOL</a>
 

 

