---
UID: NS:wmsdkidl._WMReaderClientInfo
title: WM_READER_CLIENTINFO (wmsdkidl.h)
description: The WM_READER_CLIENTINFO structure describes the client reader (player) accessing the media stream.
old-location: wmformat\wm_reader_clientinfo.htm
tech.root: wmformat
ms.assetid: 9c8d1534-976d-4a9e-9c89-368e1a11bd26
ms.date: 12/05/2018
ms.keywords: WM_READER_CLIENTINFO, WM_READER_CLIENTINFO structure [windows Media Format], wmformat.wm_reader_clientinfo, wmsdkidl/WM_READER_CLIENTINFO
f1_keywords:
- wmsdkidl/WM_READER_CLIENTINFO
dev_langs:
- c++
req.header: wmsdkidl.h
req.include-header: Wmsdk.h
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only],Windows Media Format 7 SDK, or later versions of the SDK
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Wmsdkidl.h
api_name:
- WM_READER_CLIENTINFO
targetos: Windows
req.typenames: WM_READER_CLIENTINFO
req.redist: 
ms.custom: 19H1
---

# WM_READER_CLIENTINFO structure


## -description



The <b>WM_READER_CLIENTINFO</b> structure describes the client reader (player) accessing the media stream.




## -struct-fields




### -field cbSize

Size of the structure in bytes.


### -field wszLang

Two-letter or three-letter language code.


### -field wszBrowserUserAgent

The browser's user-agent string.


### -field wszBrowserWebPage

Web page that contains the <a href="https://docs.microsoft.com/windows/desktop/wmformat/wmformat-glossary">plug-in</a>.


### -field qwReserved

Reserved.


### -field pReserved

Unused. See Remarks.


### -field wszHostExe

Host application's .exe file; for example, Iexplore.exe.


### -field qwHostVersion

Version number of the host application. The value is four unsigned <b>WORD</b> values packed into a 64-bit integer. When the client information is logged, each <b>WORD</b> value is unpacked and translated into its decimal equivalent. For example, if the value is 0x0001000200030004, the version number is logged as "1.2.3.4".


### -field wszPlayerUserAgent

String identifying the player application. For example, "WMPlayer/9.0.0.0" identifies version 9 of the Windows Media Player.


## -remarks



In earlier versions of this SDK, the <b>pReserved</b> member was named <b>wszHostUniquePID</b>. The application used this member to specify an ID to send to the server. In the current version, the reader object automatically generates a GUID for the ID, so this structure member is obsolete. It is present only to provide binary compatibility with earlier versions of the SDK.

The GUID generated by the reader object represents a unique user on a particular computer. The reader object stores this value in the registry. If the registry entry does not exist, the SDK dynamically creates it. For more information, see <a href="https://docs.microsoft.com/windows/desktop/api/wmsdkidl/nf-wmsdkidl-iwmreaderadvanced2-setlogclientid">IWMReaderAdvanced2::SetLogClientID</a>.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/wmsdkidl/nf-wmsdkidl-iwmreaderadvanced-setclientinfo">IWMReaderAdvanced::SetClientInfo</a>



<a href="https://docs.microsoft.com/windows/desktop/wmformat/structures">Structures</a>
 

 

