---
UID: NE:wpcevent.tagWPC_MEDIA_TYPE
title: WPC_MEDIA_TYPE (wpcevent.h)
description: Indicates information about the type of media file accessed.
old-location: parcon\wpc_media_type.htm
tech.root: parcon
ms.assetid: 256fdf95-894c-41a1-b72f-26d5f9b86c3d
ms.date: 12/05/2018
ms.keywords: WPC_MEDIA_TYPE, WPC_MEDIA_TYPE enumeration, WPC_MEDIA_TYPE_AUDIO_FILE, WPC_MEDIA_TYPE_CD_AUDIO, WPC_MEDIA_TYPE_DVD, WPC_MEDIA_TYPE_MAX, WPC_MEDIA_TYPE_OTHER, WPC_MEDIA_TYPE_PICTURE_FILE, WPC_MEDIA_TYPE_RECORDED_TV, WPC_MEDIA_TYPE_VIDEO_FILE, parcon.wpc_media_type, wpcevent/WPC_MEDIA_TYPE, wpcevent/WPC_MEDIA_TYPE_AUDIO_FILE, wpcevent/WPC_MEDIA_TYPE_CD_AUDIO, wpcevent/WPC_MEDIA_TYPE_DVD, wpcevent/WPC_MEDIA_TYPE_MAX, wpcevent/WPC_MEDIA_TYPE_OTHER, wpcevent/WPC_MEDIA_TYPE_PICTURE_FILE, wpcevent/WPC_MEDIA_TYPE_RECORDED_TV, wpcevent/WPC_MEDIA_TYPE_VIDEO_FILE
f1_keywords:
- wpcevent/WPC_MEDIA_TYPE
dev_langs:
- c++
req.header: wpcevent.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: None supported
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Wpcevent.h
api_name:
- WPC_MEDIA_TYPE
targetos: Windows
req.typenames: WPC_MEDIA_TYPE
req.redist: 
ms.custom: 19H1
---

# WPC_MEDIA_TYPE enumeration


## -description


Indicates information about the type of media file accessed.


## -enum-fields




### -field WPC_MEDIA_TYPE_OTHER

The type of media file accessed is not one of the types available.


### -field WPC_MEDIA_TYPE_DVD

The type of media file accessed is a DVD.


### -field WPC_MEDIA_TYPE_RECORDED_TV

The type of media file accessed is recorded television.


### -field WPC_MEDIA_TYPE_AUDIO_FILE

The type of media file accessed is an audio file other than a CD audio file.


### -field WPC_MEDIA_TYPE_CD_AUDIO

The type of media file accessed is a CD audio file.


### -field WPC_MEDIA_TYPE_VIDEO_FILE

The type of media file accessed is a video file.


### -field WPC_MEDIA_TYPE_PICTURE_FILE

The type of media file accessed is a picture file.


### -field WPC_MEDIA_TYPE_MAX

The type of media file accessed is a .max file.

